package com.ruoyi.project.cmplant.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 试验管理-试件管理对象 production_sjgl
 * 
 * @author lihang
 * @date 2020-08-27
 */
public class ProductionSjgl extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** 试件管理ID */
	private Long sjglId;

	/** 市 */
	@Excel(name = "市")
	private String shiji;

	/** 区县 */
	@Excel(name = "区县")
	private String xzqhmc;

	/** 企业名称 */
	@Excel(name = "企业名称")
	private String eninfoName;

	/** 搅拌站名称 */
	@Excel(name = "搅拌站名称")
	private String miplantName;

	/** 搅拌站ID */
	@Excel(name = "搅拌站ID")
	private Long miplantId;

	/** 试件编号 */
	@Excel(name = "试件编号")
	private String sjglSjbh;

	/** 试件生成日期 */
	@JsonFormat(pattern = "yyyy-MM-dd")
	@Excel(name = "试件生成日期", width = 30, dateFormat = "yyyy-MM-dd")
	private Date sjglSjscrq;

	/** 试验编号 */
	@Excel(name = "试验编号")
	private String sjglSybh;

	/** 试块抗压强度 */
	@Excel(name = "试块抗压强度")
	private String sjglSkkyqd;

	/** 试件存放位置 */
	@Excel(name = "试件存放位置")
	private String sjglSkcfwz;

	/** 试件存放条件 */
	@Excel(name = "试件存放条件")
	private String sjglSkcftj;

	/** 状态 0删除 1保存 2上报 */
	@Excel(name = "状态 0删除 1保存 2上报")
	private Integer status;

	public String getShiji() {
		return shiji;
	}

	public void setShiji(String shiji) {
		this.shiji = shiji;
	}

	public String getXzqhmc() {
		return xzqhmc;
	}

	public void setXzqhmc(String xzqhmc) {
		this.xzqhmc = xzqhmc;
	}

	public String getEninfoName() {
		return eninfoName;
	}

	public void setEninfoName(String eninfoName) {
		this.eninfoName = eninfoName;
	}

	public String getMiplantName() {
		return miplantName;
	}

	public void setMiplantName(String miplantName) {
		this.miplantName = miplantName;
	}

	public void setSjglId(Long sjglId) {
		this.sjglId = sjglId;
	}

	public Long getSjglId() {
		return sjglId;
	}

	public void setMiplantId(Long miplantId) {
		this.miplantId = miplantId;
	}

	public Long getMiplantId() {
		return miplantId;
	}

	public void setSjglSjbh(String sjglSjbh) {
		this.sjglSjbh = sjglSjbh;
	}

	public String getSjglSjbh() {
		return sjglSjbh;
	}

	public void setSjglSjscrq(Date sjglSjscrq) {
		this.sjglSjscrq = sjglSjscrq;
	}

	public Date getSjglSjscrq() {
		return sjglSjscrq;
	}

	public void setSjglSybh(String sjglSybh) {
		this.sjglSybh = sjglSybh;
	}

	public String getSjglSybh() {
		return sjglSybh;
	}

	public void setSjglSkkyqd(String sjglSkkyqd) {
		this.sjglSkkyqd = sjglSkkyqd;
	}

	public String getSjglSkkyqd() {
		return sjglSkkyqd;
	}

	public void setSjglSkcfwz(String sjglSkcfwz) {
		this.sjglSkcfwz = sjglSkcfwz;
	}

	public String getSjglSkcfwz() {
		return sjglSkcfwz;
	}

	public void setSjglSkcftj(String sjglSkcftj) {
		this.sjglSkcftj = sjglSkcftj;
	}

	public String getSjglSkcftj() {
		return sjglSkcftj;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Integer getStatus() {
		return status;
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("sjglId", getSjglId())
				.append("miplantId", getMiplantId()).append("sjglSjbh", getSjglSjbh())
				.append("sjglSjscrq", getSjglSjscrq()).append("sjglSybh", getSjglSybh())
				.append("sjglSkkyqd", getSjglSkkyqd()).append("sjglSkcfwz", getSjglSkcfwz())
				.append("sjglSkcftj", getSjglSkcftj()).append("status", getStatus()).append("createBy", getCreateBy())
				.append("createTime", getCreateTime()).append("updateBy", getUpdateBy())
				.append("updateTime", getUpdateTime()).append("remark", getRemark()).toString();
	}
}
