package com.ruoyi.project.cmplant.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 运输管理-任务管理对象 transport_rwgl
 * 
 * @author lihang
 * @date 2020-08-27
 */
public class TransportRwgl extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** 任务管理ID */
	private Long rwglId;

	/** 市 */
	@Excel(name = "市")
	private String shiji;

	/** 区县 */
	@Excel(name = "区县")
	private String xzqhmc;

	/** 企业名称 */
	@Excel(name = "企业名称")
	private String eninfoName;

	/** 搅拌站名称 */
	@Excel(name = "搅拌站名称")
	private String miplantName;

	/** 企业ID */
	@Excel(name = "企业ID")
	private Long eninfoId;

	/** 日期 */
	@JsonFormat(pattern = "yyyy-MM-dd")
	@Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd")
	private Date rwglRq;

	/** 司机名称 */
	@Excel(name = "司机名称")
	private String rwglSjmc;

	/** 车辆牌照 */
	@Excel(name = "车辆牌照")
	private String rwglClpz;

	/** 搅拌站ID */
	@Excel(name = "搅拌站ID")
	private Long miplantId;

	/** 开始时间 */
	@JsonFormat(pattern = "yyyy-MM-dd")
	@Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd")
	private Date rwglKssj;

	/** 车次 */
	@Excel(name = "车次")
	private String rwglCc;

	/** 路线 */
	@Excel(name = "路线")
	private String rwglLx;

	/** 状态 0删除 1保存 2上报 */
	@Excel(name = "状态 0删除 1保存 2上报")
	private Integer status;

	public String getShiji() {
		return shiji;
	}

	public void setShiji(String shiji) {
		this.shiji = shiji;
	}

	public String getXzqhmc() {
		return xzqhmc;
	}

	public void setXzqhmc(String xzqhmc) {
		this.xzqhmc = xzqhmc;
	}

	public String getEninfoName() {
		return eninfoName;
	}

	public void setEninfoName(String eninfoName) {
		this.eninfoName = eninfoName;
	}

	public String getMiplantName() {
		return miplantName;
	}

	public void setMiplantName(String miplantName) {
		this.miplantName = miplantName;
	}

	public void setRwglId(Long rwglId) {
		this.rwglId = rwglId;
	}

	public Long getRwglId() {
		return rwglId;
	}

	public void setEninfoId(Long eninfoId) {
		this.eninfoId = eninfoId;
	}

	public Long getEninfoId() {
		return eninfoId;
	}

	public void setRwglRq(Date rwglRq) {
		this.rwglRq = rwglRq;
	}

	public Date getRwglRq() {
		return rwglRq;
	}

	public void setRwglSjmc(String rwglSjmc) {
		this.rwglSjmc = rwglSjmc;
	}

	public String getRwglSjmc() {
		return rwglSjmc;
	}

	public void setRwglClpz(String rwglClpz) {
		this.rwglClpz = rwglClpz;
	}

	public String getRwglClpz() {
		return rwglClpz;
	}

	public void setMiplantId(Long miplantId) {
		this.miplantId = miplantId;
	}

	public Long getMiplantId() {
		return miplantId;
	}

	public void setRwglKssj(Date rwglKssj) {
		this.rwglKssj = rwglKssj;
	}

	public Date getRwglKssj() {
		return rwglKssj;
	}

	public void setRwglCc(String rwglCc) {
		this.rwglCc = rwglCc;
	}

	public String getRwglCc() {
		return rwglCc;
	}

	public void setRwglLx(String rwglLx) {
		this.rwglLx = rwglLx;
	}

	public String getRwglLx() {
		return rwglLx;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Integer getStatus() {
		return status;
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("rwglId", getRwglId())
				.append("eninfoId", getEninfoId()).append("rwglRq", getRwglRq()).append("rwglSjmc", getRwglSjmc())
				.append("rwglClpz", getRwglClpz()).append("miplantId", getMiplantId()).append("rwglKssj", getRwglKssj())
				.append("rwglCc", getRwglCc()).append("rwglLx", getRwglLx()).append("status", getStatus())
				.append("createBy", getCreateBy()).append("createTime", getCreateTime())
				.append("updateBy", getUpdateBy()).append("updateTime", getUpdateTime()).append("remark", getRemark())
				.toString();
	}
}
