package com.ruoyi.project.cmplant.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 运输管理-运输记录对象 transport_ysjc
 * 
 * @author lihang
 * @date 2020-08-27
 */
public class TransportYsjc extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** 运输记录ID */
	private Long ysjlId;

	/** 市 */
	@Excel(name = "市")
	private String shiji;

	/** 区县 */
	@Excel(name = "区县")
	private String xzqhmc;

	/** 企业名称 */
	@Excel(name = "企业名称")
	private String eninfoName;

	/** 搅拌站名称 */
	@Excel(name = "搅拌站名称")
	private String miplantName;

	/** 企业ID */
	@Excel(name = "企业ID")
	private Long eninfoId;

	/** 司机名称 */
	@Excel(name = "司机名称")
	private String ysjlSjmc;

	/** 车辆编号 */
	@Excel(name = "车辆编号")
	private Long carId;

	/** 搅拌站名称 */
	@Excel(name = "搅拌站名称")
	private Long miplantId;

	/** 开始时间 */
	@JsonFormat(pattern = "yyyy-MM-dd")
	@Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd")
	private Date ysjlKssj;

	/** 结束时间 */
	@JsonFormat(pattern = "yyyy-MM-dd")
	@Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
	private Date ysjlJssj;

	/** 发运方量（m³） */
	@Excel(name = "发运方量", readConverterExp = "m=³")
	private Double ysjlFyfl;

	/** 路线 */
	@Excel(name = "路线")
	private String ysjlLx;

	/** 是否异常 */
	@Excel(name = "是否异常")
	private String ysjlSfyc;

	/** 状态 0删除 1保存 2上报 */
	@Excel(name = "状态 0删除 1保存 2上报")
	private Integer status;

	public String getShiji() {
		return shiji;
	}

	public void setShiji(String shiji) {
		this.shiji = shiji;
	}

	public String getXzqhmc() {
		return xzqhmc;
	}

	public void setXzqhmc(String xzqhmc) {
		this.xzqhmc = xzqhmc;
	}

	public String getEninfoName() {
		return eninfoName;
	}

	public void setEninfoName(String eninfoName) {
		this.eninfoName = eninfoName;
	}

	public String getMiplantName() {
		return miplantName;
	}

	public void setMiplantName(String miplantName) {
		this.miplantName = miplantName;
	}

	public void setYsjlId(Long ysjlId) {
		this.ysjlId = ysjlId;
	}

	public Long getYsjlId() {
		return ysjlId;
	}

	public void setEninfoId(Long eninfoId) {
		this.eninfoId = eninfoId;
	}

	public Long getEninfoId() {
		return eninfoId;
	}

	public void setYsjlSjmc(String ysjlSjmc) {
		this.ysjlSjmc = ysjlSjmc;
	}

	public String getYsjlSjmc() {
		return ysjlSjmc;
	}

	public void setCarId(Long carId) {
		this.carId = carId;
	}

	public Long getCarId() {
		return carId;
	}

	public void setMiplantId(Long miplantId) {
		this.miplantId = miplantId;
	}

	public Long getMiplantId() {
		return miplantId;
	}

	public void setYsjlKssj(Date ysjlKssj) {
		this.ysjlKssj = ysjlKssj;
	}

	public Date getYsjlKssj() {
		return ysjlKssj;
	}

	public void setYsjlJssj(Date ysjlJssj) {
		this.ysjlJssj = ysjlJssj;
	}

	public Date getYsjlJssj() {
		return ysjlJssj;
	}

	public void setYsjlFyfl(Double ysjlFyfl) {
		this.ysjlFyfl = ysjlFyfl;
	}

	public Double getYsjlFyfl() {
		return ysjlFyfl;
	}

	public void setYsjlLx(String ysjlLx) {
		this.ysjlLx = ysjlLx;
	}

	public String getYsjlLx() {
		return ysjlLx;
	}

	public void setYsjlSfyc(String ysjlSfyc) {
		this.ysjlSfyc = ysjlSfyc;
	}

	public String getYsjlSfyc() {
		return ysjlSfyc;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Integer getStatus() {
		return status;
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("ysjlId", getYsjlId())
				.append("eninfoId", getEninfoId()).append("ysjlSjmc", getYsjlSjmc()).append("carId", getCarId())
				.append("miplantId", getMiplantId()).append("ysjlKssj", getYsjlKssj()).append("ysjlJssj", getYsjlJssj())
				.append("ysjlFyfl", getYsjlFyfl()).append("ysjlLx", getYsjlLx()).append("ysjlSfyc", getYsjlSfyc())
				.append("status", getStatus()).append("createBy", getCreateBy()).append("createTime", getCreateTime())
				.append("updateBy", getUpdateBy()).append("updateTime", getUpdateTime()).append("remark", getRemark())
				.toString();
	}
}
