package com.ruoyi.project.cmplant.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 运输管理-运输监测对象 transport_ysjl
 * 
 * @author lihang
 * @date 2020-08-27
 */
public class TransportYsjl extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** 运输监测ID */
	private Long ysjcId;

	/** 市 */
	@Excel(name = "市")
	private String shiji;

	/** 区县 */
	@Excel(name = "区县")
	private String xzqhmc;

	/** 企业名称 */
	@Excel(name = "企业名称")
	private String eninfoName;

	/** 搅拌站名称 */
	@Excel(name = "搅拌站名称")
	private String miplantName;

	/** 企业ID */
	@Excel(name = "企业ID")
	private Long eninfoId;

	/** 车牌号码 */
	@Excel(name = "车牌号码")
	private String ysjcCphm;

	/** 报警类型 */
	@Excel(name = "报警类型")
	private String ysjcBjlx;

	/** 报警时间 */
	@JsonFormat(pattern = "yyyy-MM-dd")
	@Excel(name = "报警时间", width = 30, dateFormat = "yyyy-MM-dd")
	private Date ysjcBjsj;

	/** 处理方式 */
	@Excel(name = "处理方式")
	private String ysjcClfs;

	/** 处理时间 */
	@JsonFormat(pattern = "yyyy-MM-dd")
	@Excel(name = "处理时间", width = 30, dateFormat = "yyyy-MM-dd")
	private Date ysjcClsj;

	/** 状态 0删除 1保存 2上报 */
	@Excel(name = "状态 0删除 1保存 2上报")
	private Integer status;

	public void setYsjcId(Long ysjcId) {
		this.ysjcId = ysjcId;
	}

	public String getShiji() {
		return shiji;
	}

	public void setShiji(String shiji) {
		this.shiji = shiji;
	}

	public String getXzqhmc() {
		return xzqhmc;
	}

	public void setXzqhmc(String xzqhmc) {
		this.xzqhmc = xzqhmc;
	}

	public String getEninfoName() {
		return eninfoName;
	}

	public void setEninfoName(String eninfoName) {
		this.eninfoName = eninfoName;
	}

	public String getMiplantName() {
		return miplantName;
	}

	public void setMiplantName(String miplantName) {
		this.miplantName = miplantName;
	}

	public Long getYsjcId() {
		return ysjcId;
	}

	public void setEninfoId(Long eninfoId) {
		this.eninfoId = eninfoId;
	}

	public Long getEninfoId() {
		return eninfoId;
	}

	public void setYsjcCphm(String ysjcCphm) {
		this.ysjcCphm = ysjcCphm;
	}

	public String getYsjcCphm() {
		return ysjcCphm;
	}

	public void setYsjcBjlx(String ysjcBjlx) {
		this.ysjcBjlx = ysjcBjlx;
	}

	public String getYsjcBjlx() {
		return ysjcBjlx;
	}

	public void setYsjcBjsj(Date ysjcBjsj) {
		this.ysjcBjsj = ysjcBjsj;
	}

	public Date getYsjcBjsj() {
		return ysjcBjsj;
	}

	public void setYsjcClfs(String ysjcClfs) {
		this.ysjcClfs = ysjcClfs;
	}

	public String getYsjcClfs() {
		return ysjcClfs;
	}

	public void setYsjcClsj(Date ysjcClsj) {
		this.ysjcClsj = ysjcClsj;
	}

	public Date getYsjcClsj() {
		return ysjcClsj;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Integer getStatus() {
		return status;
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("ysjcId", getYsjcId())
				.append("eninfoId", getEninfoId()).append("ysjcCphm", getYsjcCphm()).append("ysjcBjlx", getYsjcBjlx())
				.append("ysjcBjsj", getYsjcBjsj()).append("ysjcClfs", getYsjcClfs()).append("ysjcClsj", getYsjcClsj())
				.append("status", getStatus()).append("createBy", getCreateBy()).append("createTime", getCreateTime())
				.append("updateBy", getUpdateBy()).append("updateTime", getUpdateTime()).append("remark", getRemark())
				.toString();
	}
}
