package com.ruoyi.project.cmplant.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 运输管理-运输统计对象 transport_ystj
 * 
 * @author lihang
 * @date 2020-08-27
 */
public class TransportYstj extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** 运输统计ID */
	private Long ystjId;

	/** 企业ID */
	@Excel(name = "企业ID")
	private Long eninfoId;

	/** 市 */
	@Excel(name = "市")
	private String shiji;

	/** 区县 */
	@Excel(name = "区县")
	private String xzqhmc;

	/** 企业名称 */
	@Excel(name = "企业名称")
	private String eninfoName;

	/** 搅拌站名称 */
	@Excel(name = "搅拌站名称")
	private String miplantName;

	/** 车辆编号 */
	@Excel(name = "车辆编号")
	private Long carId;

	/** 行驶公里数 */
	@Excel(name = "行驶公里数")
	private Double ystjSsgls;

	/** 发运方量（m³） */
	@Excel(name = "发运方量", readConverterExp = "m=³")
	private Double ystjFyfl;

	/** 油耗 */
	@Excel(name = "油耗")
	private Double ystjYh;

	/** 状态 0删除 1保存 2上报 */
	@Excel(name = "状态 0删除 1保存 2上报")
	private Integer status;

	public void setYstjId(Long ystjId) {
		this.ystjId = ystjId;
	}

	public String getShiji() {
		return shiji;
	}

	public void setShiji(String shiji) {
		this.shiji = shiji;
	}

	public String getXzqhmc() {
		return xzqhmc;
	}

	public void setXzqhmc(String xzqhmc) {
		this.xzqhmc = xzqhmc;
	}

	public String getEninfoName() {
		return eninfoName;
	}

	public void setEninfoName(String eninfoName) {
		this.eninfoName = eninfoName;
	}

	public String getMiplantName() {
		return miplantName;
	}

	public void setMiplantName(String miplantName) {
		this.miplantName = miplantName;
	}

	public Long getYstjId() {
		return ystjId;
	}

	public void setEninfoId(Long eninfoId) {
		this.eninfoId = eninfoId;
	}

	public Long getEninfoId() {
		return eninfoId;
	}

	public void setCarId(Long carId) {
		this.carId = carId;
	}

	public Long getCarId() {
		return carId;
	}

	public void setYstjSsgls(Double ystjSsgls) {
		this.ystjSsgls = ystjSsgls;
	}

	public Double getYstjSsgls() {
		return ystjSsgls;
	}

	public void setYstjFyfl(Double ystjFyfl) {
		this.ystjFyfl = ystjFyfl;
	}

	public Double getYstjFyfl() {
		return ystjFyfl;
	}

	public void setYstjYh(Double ystjYh) {
		this.ystjYh = ystjYh;
	}

	public Double getYstjYh() {
		return ystjYh;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Integer getStatus() {
		return status;
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("ystjId", getYstjId())
				.append("eninfoId", getEninfoId()).append("carId", getCarId()).append("ystjSsgls", getYstjSsgls())
				.append("ystjFyfl", getYstjFyfl()).append("ystjYh", getYstjYh()).append("status", getStatus())
				.append("createBy", getCreateBy()).append("createTime", getCreateTime())
				.append("updateBy", getUpdateBy()).append("updateTime", getUpdateTime()).append("remark", getRemark())
				.toString();
	}
}
