package com.ruoyi.project.cmplant.mapper;

import java.util.List;
import com.ruoyi.project.cmplant.domain.BainfoEninfo;

/**
 * 基础信息-企业信息Mapper接口
 * 
 * @author lihang
 * @date 2020-08-26
 */
public interface BainfoEninfoMapper 
{
    /**
     * 查询基础信息-企业信息
     * 
     * @param eninfoId 基础信息-企业信息ID
     * @return 基础信息-企业信息
     */
    public BainfoEninfo selectBainfoEninfoById(Long eninfoId);

    /**
     * 查询基础信息-企业信息列表
     * 
     * @param bainfoEninfo 基础信息-企业信息
     * @return 基础信息-企业信息集合
     */
    public List<BainfoEninfo> selectBainfoEninfoList(BainfoEninfo bainfoEninfo);

    /**
     * 新增基础信息-企业信息
     * 
     * @param bainfoEninfo 基础信息-企业信息
     * @return 结果
     */
    public int insertBainfoEninfo(BainfoEninfo bainfoEninfo);

    /**
     * 修改基础信息-企业信息
     * 
     * @param bainfoEninfo 基础信息-企业信息
     * @return 结果
     */
    public int updateBainfoEninfo(BainfoEninfo bainfoEninfo);

    /**
     * 删除基础信息-企业信息
     * 
     * @param eninfoId 基础信息-企业信息ID
     * @return 结果
     */
    public int deleteBainfoEninfoById(Long eninfoId);

    /**
     * 批量删除基础信息-企业信息
     * 
     * @param eninfoIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteBainfoEninfoByIds(Long[] eninfoIds);
}
