package com.ruoyi.project.cmplant.mapper;

import java.util.List;
import com.ruoyi.project.cmplant.domain.ProDatmon;

/**
 * 生产管理-数据监测Mapper接口
 * 
 * @author lihang
 * @date 2020-08-28
 */
public interface ProDatmonMapper 
{
    /**
     * 查询生产管理-数据监测
     * 
     * @param damonId 生产管理-数据监测ID
     * @return 生产管理-数据监测
     */
    public ProDatmon selectProDatmonById(Long damonId);

    /**
     * 查询生产管理-数据监测列表
     * 
     * @param proDatmon 生产管理-数据监测
     * @return 生产管理-数据监测集合
     */
    public List<ProDatmon> selectProDatmonList(ProDatmon proDatmon);

    /**
     * 新增生产管理-数据监测
     * 
     * @param proDatmon 生产管理-数据监测
     * @return 结果
     */
    public int insertProDatmon(ProDatmon proDatmon);

    /**
     * 修改生产管理-数据监测
     * 
     * @param proDatmon 生产管理-数据监测
     * @return 结果
     */
    public int updateProDatmon(ProDatmon proDatmon);

    /**
     * 删除生产管理-数据监测
     * 
     * @param damonId 生产管理-数据监测ID
     * @return 结果
     */
    public int deleteProDatmonById(Long damonId);

    /**
     * 批量删除生产管理-数据监测
     * 
     * @param damonIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteProDatmonByIds(Long[] damonIds);
}
