package com.ruoyi.project.cmplant.mapper;

import java.util.List;
import com.ruoyi.project.cmplant.domain.ProPur;

/**
 * 生产管理-采购订单Mapper接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface ProPurMapper 
{
    /**
     * 查询生产管理-采购订单
     * 
     * @param purId 生产管理-采购订单ID
     * @return 生产管理-采购订单
     */
    public ProPur selectProPurById(Long purId);

    /**
     * 查询生产管理-采购订单列表
     * 
     * @param proPur 生产管理-采购订单
     * @return 生产管理-采购订单集合
     */
    public List<ProPur> selectProPurList(ProPur proPur);

    /**
     * 新增生产管理-采购订单
     * 
     * @param proPur 生产管理-采购订单
     * @return 结果
     */
    public int insertProPur(ProPur proPur);

    /**
     * 修改生产管理-采购订单
     * 
     * @param proPur 生产管理-采购订单
     * @return 结果
     */
    public int updateProPur(ProPur proPur);

    /**
     * 删除生产管理-采购订单
     * 
     * @param purId 生产管理-采购订单ID
     * @return 结果
     */
    public int deleteProPurById(Long purId);

    /**
     * 批量删除生产管理-采购订单
     * 
     * @param purIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteProPurByIds(Long[] purIds);
}
