package com.ruoyi.project.cmplant.mapper;

import java.util.List;
import com.ruoyi.project.cmplant.domain.ProPurPdet;

/**
 * 生产管理-采购订单-采购明细Mapper接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface ProPurPdetMapper 
{
    /**
     * 查询生产管理-采购订单-采购明细
     * 
     * @param pdetId 生产管理-采购订单-采购明细ID
     * @return 生产管理-采购订单-采购明细
     */
    public ProPurPdet selectProPurPdetById(Long pdetId);

    /**
     * 查询生产管理-采购订单-采购明细列表
     * 
     * @param proPurPdet 生产管理-采购订单-采购明细
     * @return 生产管理-采购订单-采购明细集合
     */
    public List<ProPurPdet> selectProPurPdetList(ProPurPdet proPurPdet);

    /**
     * 新增生产管理-采购订单-采购明细
     * 
     * @param proPurPdet 生产管理-采购订单-采购明细
     * @return 结果
     */
    public int insertProPurPdet(ProPurPdet proPurPdet);

    /**
     * 修改生产管理-采购订单-采购明细
     * 
     * @param proPurPdet 生产管理-采购订单-采购明细
     * @return 结果
     */
    public int updateProPurPdet(ProPurPdet proPurPdet);

    /**
     * 删除生产管理-采购订单-采购明细
     * 
     * @param pdetId 生产管理-采购订单-采购明细ID
     * @return 结果
     */
    public int deleteProPurPdetById(Long pdetId);

    /**
     * 批量删除生产管理-采购订单-采购明细
     * 
     * @param pdetIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteProPurPdetByIds(Long[] pdetIds);
}
