package com.ruoyi.project.cmplant.mapper;

import java.util.List;
import com.ruoyi.project.cmplant.domain.ProSales;

/**
 * 生产管理-销售订单Mapper接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface ProSalesMapper 
{
    /**
     * 查询生产管理-销售订单
     * 
     * @param salesId 生产管理-销售订单ID
     * @return 生产管理-销售订单
     */
    public ProSales selectProSalesById(Long salesId);

    /**
     * 查询生产管理-销售订单列表
     * 
     * @param proSales 生产管理-销售订单
     * @return 生产管理-销售订单集合
     */
    public List<ProSales> selectProSalesList(ProSales proSales);

    /**
     * 新增生产管理-销售订单
     * 
     * @param proSales 生产管理-销售订单
     * @return 结果
     */
    public int insertProSales(ProSales proSales);

    /**
     * 修改生产管理-销售订单
     * 
     * @param proSales 生产管理-销售订单
     * @return 结果
     */
    public int updateProSales(ProSales proSales);

    /**
     * 删除生产管理-销售订单
     * 
     * @param salesId 生产管理-销售订单ID
     * @return 结果
     */
    public int deleteProSalesById(Long salesId);

    /**
     * 批量删除生产管理-销售订单
     * 
     * @param salesIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteProSalesByIds(Long[] salesIds);
}
