package com.ruoyi.project.cmplant.mapper;

import java.util.List;
import com.ruoyi.project.cmplant.domain.ProductionSy;

/**
 * 试验管理-溯源Mapper接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface ProductionSyMapper 
{
    /**
     * 查询试验管理-溯源
     * 
     * @param syId 试验管理-溯源ID
     * @return 试验管理-溯源
     */
    public ProductionSy selectProductionSyById(Long syId);

    /**
     * 查询试验管理-溯源列表
     * 
     * @param productionSy 试验管理-溯源
     * @return 试验管理-溯源集合
     */
    public List<ProductionSy> selectProductionSyList(ProductionSy productionSy);

    /**
     * 新增试验管理-溯源
     * 
     * @param productionSy 试验管理-溯源
     * @return 结果
     */
    public int insertProductionSy(ProductionSy productionSy);

    /**
     * 修改试验管理-溯源
     * 
     * @param productionSy 试验管理-溯源
     * @return 结果
     */
    public int updateProductionSy(ProductionSy productionSy);

    /**
     * 删除试验管理-溯源
     * 
     * @param syId 试验管理-溯源ID
     * @return 结果
     */
    public int deleteProductionSyById(Long syId);

    /**
     * 批量删除试验管理-溯源
     * 
     * @param syIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteProductionSyByIds(Long[] syIds);
}
