package com.ruoyi.project.cmplant.mapper;

import java.util.List;
import com.ruoyi.project.cmplant.domain.TransportRwgl;

/**
 * 运输管理-任务管理Mapper接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface TransportRwglMapper 
{
    /**
     * 查询运输管理-任务管理
     * 
     * @param rwglId 运输管理-任务管理ID
     * @return 运输管理-任务管理
     */
    public TransportRwgl selectTransportRwglById(Long rwglId);

    /**
     * 查询运输管理-任务管理列表
     * 
     * @param transportRwgl 运输管理-任务管理
     * @return 运输管理-任务管理集合
     */
    public List<TransportRwgl> selectTransportRwglList(TransportRwgl transportRwgl);

    /**
     * 新增运输管理-任务管理
     * 
     * @param transportRwgl 运输管理-任务管理
     * @return 结果
     */
    public int insertTransportRwgl(TransportRwgl transportRwgl);

    /**
     * 修改运输管理-任务管理
     * 
     * @param transportRwgl 运输管理-任务管理
     * @return 结果
     */
    public int updateTransportRwgl(TransportRwgl transportRwgl);

    /**
     * 删除运输管理-任务管理
     * 
     * @param rwglId 运输管理-任务管理ID
     * @return 结果
     */
    public int deleteTransportRwglById(Long rwglId);

    /**
     * 批量删除运输管理-任务管理
     * 
     * @param rwglIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTransportRwglByIds(Long[] rwglIds);
}
