package com.ruoyi.project.cmplant.mapper;

import java.util.List;
import com.ruoyi.project.cmplant.domain.TransportYslxsz;

/**
 * 运输管理-运输路线设置Mapper接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface TransportYslxszMapper 
{
    /**
     * 查询运输管理-运输路线设置
     * 
     * @param yslxszId 运输管理-运输路线设置ID
     * @return 运输管理-运输路线设置
     */
    public TransportYslxsz selectTransportYslxszById(Long yslxszId);

    /**
     * 查询运输管理-运输路线设置列表
     * 
     * @param transportYslxsz 运输管理-运输路线设置
     * @return 运输管理-运输路线设置集合
     */
    public List<TransportYslxsz> selectTransportYslxszList(TransportYslxsz transportYslxsz);

    /**
     * 新增运输管理-运输路线设置
     * 
     * @param transportYslxsz 运输管理-运输路线设置
     * @return 结果
     */
    public int insertTransportYslxsz(TransportYslxsz transportYslxsz);

    /**
     * 修改运输管理-运输路线设置
     * 
     * @param transportYslxsz 运输管理-运输路线设置
     * @return 结果
     */
    public int updateTransportYslxsz(TransportYslxsz transportYslxsz);

    /**
     * 删除运输管理-运输路线设置
     * 
     * @param yslxszId 运输管理-运输路线设置ID
     * @return 结果
     */
    public int deleteTransportYslxszById(Long yslxszId);

    /**
     * 批量删除运输管理-运输路线设置
     * 
     * @param yslxszIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTransportYslxszByIds(Long[] yslxszIds);
}
