package com.ruoyi.project.cmplant.service;

import java.util.List;
import com.ruoyi.project.cmplant.domain.BainfoCar;

/**
 * 基础信息-车辆管理Service接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface IBainfoCarService 
{
    /**
     * 查询基础信息-车辆管理
     * 
     * @param carId 基础信息-车辆管理ID
     * @return 基础信息-车辆管理
     */
    public BainfoCar selectBainfoCarById(Long carId);

    /**
     * 查询基础信息-车辆管理列表
     * 
     * @param bainfoCar 基础信息-车辆管理
     * @return 基础信息-车辆管理集合
     */
    public List<BainfoCar> selectBainfoCarList(BainfoCar bainfoCar);

    /**
     * 新增基础信息-车辆管理
     * 
     * @param bainfoCar 基础信息-车辆管理
     * @return 结果
     */
    public int insertBainfoCar(BainfoCar bainfoCar);

    /**
     * 修改基础信息-车辆管理
     * 
     * @param bainfoCar 基础信息-车辆管理
     * @return 结果
     */
    public int updateBainfoCar(BainfoCar bainfoCar);

    /**
     * 批量删除基础信息-车辆管理
     * 
     * @param carIds 需要删除的基础信息-车辆管理ID
     * @return 结果
     */
    public int deleteBainfoCarByIds(Long[] carIds);

    /**
     * 删除基础信息-车辆管理信息
     * 
     * @param carId 基础信息-车辆管理ID
     * @return 结果
     */
    public int deleteBainfoCarById(Long carId);
}
