package com.ruoyi.project.cmplant.service;

import java.util.List;
import com.ruoyi.project.cmplant.domain.BainfoStaff;

/**
 * 基础信息-人员管理Service接口
 * 
 * @author lihang
 * @date 2020-08-26
 */
public interface IBainfoStaffService 
{
    /**
     * 查询基础信息-人员管理
     * 
     * @param staffId 基础信息-人员管理ID
     * @return 基础信息-人员管理
     */
    public BainfoStaff selectBainfoStaffById(Long staffId);

    /**
     * 查询基础信息-人员管理列表
     * 
     * @param bainfoStaff 基础信息-人员管理
     * @return 基础信息-人员管理集合
     */
    public List<BainfoStaff> selectBainfoStaffList(BainfoStaff bainfoStaff);

    /**
     * 新增基础信息-人员管理
     * 
     * @param bainfoStaff 基础信息-人员管理
     * @return 结果
     */
    public int insertBainfoStaff(BainfoStaff bainfoStaff);

    /**
     * 修改基础信息-人员管理
     * 
     * @param bainfoStaff 基础信息-人员管理
     * @return 结果
     */
    public int updateBainfoStaff(BainfoStaff bainfoStaff);

    /**
     * 批量删除基础信息-人员管理
     * 
     * @param staffIds 需要删除的基础信息-人员管理ID
     * @return 结果
     */
    public int deleteBainfoStaffByIds(Long[] staffIds);

    /**
     * 删除基础信息-人员管理信息
     * 
     * @param staffId 基础信息-人员管理ID
     * @return 结果
     */
    public int deleteBainfoStaffById(Long staffId);
}
