package com.ruoyi.project.cmplant.service;

import java.util.List;
import com.ruoyi.project.cmplant.domain.ProTodo;

/**
 * 生产管理-生产任务单Service接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface IProTodoService 
{
    /**
     * 查询生产管理-生产任务单
     * 
     * @param todoId 生产管理-生产任务单ID
     * @return 生产管理-生产任务单
     */
    public ProTodo selectProTodoById(Long todoId);

    /**
     * 查询生产管理-生产任务单列表
     * 
     * @param proTodo 生产管理-生产任务单
     * @return 生产管理-生产任务单集合
     */
    public List<ProTodo> selectProTodoList(ProTodo proTodo);

    /**
     * 新增生产管理-生产任务单
     * 
     * @param proTodo 生产管理-生产任务单
     * @return 结果
     */
    public int insertProTodo(ProTodo proTodo);

    /**
     * 修改生产管理-生产任务单
     * 
     * @param proTodo 生产管理-生产任务单
     * @return 结果
     */
    public int updateProTodo(ProTodo proTodo);

    /**
     * 批量删除生产管理-生产任务单
     * 
     * @param todoIds 需要删除的生产管理-生产任务单ID
     * @return 结果
     */
    public int deleteProTodoByIds(Long[] todoIds);

    /**
     * 删除生产管理-生产任务单信息
     * 
     * @param todoId 生产管理-生产任务单ID
     * @return 结果
     */
    public int deleteProTodoById(Long todoId);
}
