package com.ruoyi.project.cmplant.service;

import java.util.List;
import com.ruoyi.project.cmplant.domain.TransportYsjc;

/**
 * 运输管理-运输记录Service接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface ITransportYsjcService 
{
    /**
     * 查询运输管理-运输记录
     * 
     * @param ysjlId 运输管理-运输记录ID
     * @return 运输管理-运输记录
     */
    public TransportYsjc selectTransportYsjcById(Long ysjlId);

    /**
     * 查询运输管理-运输记录列表
     * 
     * @param transportYsjc 运输管理-运输记录
     * @return 运输管理-运输记录集合
     */
    public List<TransportYsjc> selectTransportYsjcList(TransportYsjc transportYsjc);

    /**
     * 新增运输管理-运输记录
     * 
     * @param transportYsjc 运输管理-运输记录
     * @return 结果
     */
    public int insertTransportYsjc(TransportYsjc transportYsjc);

    /**
     * 修改运输管理-运输记录
     * 
     * @param transportYsjc 运输管理-运输记录
     * @return 结果
     */
    public int updateTransportYsjc(TransportYsjc transportYsjc);

    /**
     * 批量删除运输管理-运输记录
     * 
     * @param ysjlIds 需要删除的运输管理-运输记录ID
     * @return 结果
     */
    public int deleteTransportYsjcByIds(Long[] ysjlIds);

    /**
     * 删除运输管理-运输记录信息
     * 
     * @param ysjlId 运输管理-运输记录ID
     * @return 结果
     */
    public int deleteTransportYsjcById(Long ysjlId);
}
