package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.BainfoCarMapper;
import com.ruoyi.project.cmplant.domain.BainfoCar;
import com.ruoyi.project.cmplant.service.IBainfoCarService;

/**
 * 基础信息-车辆管理Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class BainfoCarServiceImpl implements IBainfoCarService 
{
    @Autowired
    private BainfoCarMapper bainfoCarMapper;

    /**
     * 查询基础信息-车辆管理
     * 
     * @param carId 基础信息-车辆管理ID
     * @return 基础信息-车辆管理
     */
    @Override
    public BainfoCar selectBainfoCarById(Long carId)
    {
        return bainfoCarMapper.selectBainfoCarById(carId);
    }

    /**
     * 查询基础信息-车辆管理列表
     * 
     * @param bainfoCar 基础信息-车辆管理
     * @return 基础信息-车辆管理
     */
    @Override
    public List<BainfoCar> selectBainfoCarList(BainfoCar bainfoCar)
    {
        return bainfoCarMapper.selectBainfoCarList(bainfoCar);
    }

    /**
     * 新增基础信息-车辆管理
     * 
     * @param bainfoCar 基础信息-车辆管理
     * @return 结果
     */
    @Override
    public int insertBainfoCar(BainfoCar bainfoCar)
    {
        bainfoCar.setCreateTime(DateUtils.getNowDate());
        return bainfoCarMapper.insertBainfoCar(bainfoCar);
    }

    /**
     * 修改基础信息-车辆管理
     * 
     * @param bainfoCar 基础信息-车辆管理
     * @return 结果
     */
    @Override
    public int updateBainfoCar(BainfoCar bainfoCar)
    {
        bainfoCar.setUpdateTime(DateUtils.getNowDate());
        return bainfoCarMapper.updateBainfoCar(bainfoCar);
    }

    /**
     * 批量删除基础信息-车辆管理
     * 
     * @param carIds 需要删除的基础信息-车辆管理ID
     * @return 结果
     */
    @Override
    public int deleteBainfoCarByIds(Long[] carIds)
    {
        return bainfoCarMapper.deleteBainfoCarByIds(carIds);
    }

    /**
     * 删除基础信息-车辆管理信息
     * 
     * @param carId 基础信息-车辆管理ID
     * @return 结果
     */
    @Override
    public int deleteBainfoCarById(Long carId)
    {
        return bainfoCarMapper.deleteBainfoCarById(carId);
    }
}
