package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.BainfoEncertMapper;
import com.ruoyi.project.cmplant.domain.BainfoEncert;
import com.ruoyi.project.cmplant.service.IBainfoEncertService;

/**
 * 基础信息-企业资质Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-26
 */
@Service
public class BainfoEncertServiceImpl implements IBainfoEncertService 
{
    @Autowired
    private BainfoEncertMapper bainfoEncertMapper;

    /**
     * 查询基础信息-企业资质
     * 
     * @param encertId 基础信息-企业资质ID
     * @return 基础信息-企业资质
     */
    @Override
    public BainfoEncert selectBainfoEncertById(Long encertId)
    {
        return bainfoEncertMapper.selectBainfoEncertById(encertId);
    }

    /**
     * 查询基础信息-企业资质列表
     * 
     * @param bainfoEncert 基础信息-企业资质
     * @return 基础信息-企业资质
     */
    @Override
    public List<BainfoEncert> selectBainfoEncertList(BainfoEncert bainfoEncert)
    {
        return bainfoEncertMapper.selectBainfoEncertList(bainfoEncert);
    }

    /**
     * 新增基础信息-企业资质
     * 
     * @param bainfoEncert 基础信息-企业资质
     * @return 结果
     */
    @Override
    public int insertBainfoEncert(BainfoEncert bainfoEncert)
    {
        bainfoEncert.setCreateTime(DateUtils.getNowDate());
        return bainfoEncertMapper.insertBainfoEncert(bainfoEncert);
    }

    /**
     * 修改基础信息-企业资质
     * 
     * @param bainfoEncert 基础信息-企业资质
     * @return 结果
     */
    @Override
    public int updateBainfoEncert(BainfoEncert bainfoEncert)
    {
        bainfoEncert.setUpdateTime(DateUtils.getNowDate());
        return bainfoEncertMapper.updateBainfoEncert(bainfoEncert);
    }

    /**
     * 批量删除基础信息-企业资质
     * 
     * @param encertIds 需要删除的基础信息-企业资质ID
     * @return 结果
     */
    @Override
    public int deleteBainfoEncertByIds(Long[] encertIds)
    {
        return bainfoEncertMapper.deleteBainfoEncertByIds(encertIds);
    }

    /**
     * 删除基础信息-企业资质信息
     * 
     * @param encertId 基础信息-企业资质ID
     * @return 结果
     */
    @Override
    public int deleteBainfoEncertById(Long encertId)
    {
        return bainfoEncertMapper.deleteBainfoEncertById(encertId);
    }
}
