package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.BainfoEninfoMapper;
import com.ruoyi.project.cmplant.domain.BainfoEninfo;
import com.ruoyi.project.cmplant.service.IBainfoEninfoService;

/**
 * 基础信息-企业信息Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-26
 */
@Service
public class BainfoEninfoServiceImpl implements IBainfoEninfoService 
{
    @Autowired
    private BainfoEninfoMapper bainfoEninfoMapper;

    /**
     * 查询基础信息-企业信息
     * 
     * @param eninfoId 基础信息-企业信息ID
     * @return 基础信息-企业信息
     */
    @Override
    public BainfoEninfo selectBainfoEninfoById(Long eninfoId)
    {
        return bainfoEninfoMapper.selectBainfoEninfoById(eninfoId);
    }

    /**
     * 查询基础信息-企业信息列表
     * 
     * @param bainfoEninfo 基础信息-企业信息
     * @return 基础信息-企业信息
     */
    @Override
    public List<BainfoEninfo> selectBainfoEninfoList(BainfoEninfo bainfoEninfo)
    {
        return bainfoEninfoMapper.selectBainfoEninfoList(bainfoEninfo);
    }

    /**
     * 新增基础信息-企业信息
     * 
     * @param bainfoEninfo 基础信息-企业信息
     * @return 结果
     */
    @Override
    public int insertBainfoEninfo(BainfoEninfo bainfoEninfo)
    {
        bainfoEninfo.setCreateTime(DateUtils.getNowDate());
        return bainfoEninfoMapper.insertBainfoEninfo(bainfoEninfo);
    }

    /**
     * 修改基础信息-企业信息
     * 
     * @param bainfoEninfo 基础信息-企业信息
     * @return 结果
     */
    @Override
    public int updateBainfoEninfo(BainfoEninfo bainfoEninfo)
    {
        bainfoEninfo.setUpdateTime(DateUtils.getNowDate());
        return bainfoEninfoMapper.updateBainfoEninfo(bainfoEninfo);
    }

    /**
     * 批量删除基础信息-企业信息
     * 
     * @param eninfoIds 需要删除的基础信息-企业信息ID
     * @return 结果
     */
    @Override
    public int deleteBainfoEninfoByIds(Long[] eninfoIds)
    {
        return bainfoEninfoMapper.deleteBainfoEninfoByIds(eninfoIds);
    }

    /**
     * 删除基础信息-企业信息信息
     * 
     * @param eninfoId 基础信息-企业信息ID
     * @return 结果
     */
    @Override
    public int deleteBainfoEninfoById(Long eninfoId)
    {
        return bainfoEninfoMapper.deleteBainfoEninfoById(eninfoId);
    }
}
