package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.BainfoStaffMapper;
import com.ruoyi.project.cmplant.domain.BainfoStaff;
import com.ruoyi.project.cmplant.service.IBainfoStaffService;

/**
 * 基础信息-人员管理Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-26
 */
@Service
public class BainfoStaffServiceImpl implements IBainfoStaffService 
{
    @Autowired
    private BainfoStaffMapper bainfoStaffMapper;

    /**
     * 查询基础信息-人员管理
     * 
     * @param staffId 基础信息-人员管理ID
     * @return 基础信息-人员管理
     */
    @Override
    public BainfoStaff selectBainfoStaffById(Long staffId)
    {
        return bainfoStaffMapper.selectBainfoStaffById(staffId);
    }

    /**
     * 查询基础信息-人员管理列表
     * 
     * @param bainfoStaff 基础信息-人员管理
     * @return 基础信息-人员管理
     */
    @Override
    public List<BainfoStaff> selectBainfoStaffList(BainfoStaff bainfoStaff)
    {
        return bainfoStaffMapper.selectBainfoStaffList(bainfoStaff);
    }

    /**
     * 新增基础信息-人员管理
     * 
     * @param bainfoStaff 基础信息-人员管理
     * @return 结果
     */
    @Override
    public int insertBainfoStaff(BainfoStaff bainfoStaff)
    {
        bainfoStaff.setCreateTime(DateUtils.getNowDate());
        return bainfoStaffMapper.insertBainfoStaff(bainfoStaff);
    }

    /**
     * 修改基础信息-人员管理
     * 
     * @param bainfoStaff 基础信息-人员管理
     * @return 结果
     */
    @Override
    public int updateBainfoStaff(BainfoStaff bainfoStaff)
    {
        bainfoStaff.setUpdateTime(DateUtils.getNowDate());
        return bainfoStaffMapper.updateBainfoStaff(bainfoStaff);
    }

    /**
     * 批量删除基础信息-人员管理
     * 
     * @param staffIds 需要删除的基础信息-人员管理ID
     * @return 结果
     */
    @Override
    public int deleteBainfoStaffByIds(Long[] staffIds)
    {
        return bainfoStaffMapper.deleteBainfoStaffByIds(staffIds);
    }

    /**
     * 删除基础信息-人员管理信息
     * 
     * @param staffId 基础信息-人员管理ID
     * @return 结果
     */
    @Override
    public int deleteBainfoStaffById(Long staffId)
    {
        return bainfoStaffMapper.deleteBainfoStaffById(staffId);
    }
}
