package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.ProDatmonMapper;
import com.ruoyi.project.cmplant.domain.ProDatmon;
import com.ruoyi.project.cmplant.service.IProDatmonService;

/**
 * 生产管理-数据监测Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-28
 */
@Service
public class ProDatmonServiceImpl implements IProDatmonService 
{
    @Autowired
    private ProDatmonMapper proDatmonMapper;

    /**
     * 查询生产管理-数据监测
     * 
     * @param damonId 生产管理-数据监测ID
     * @return 生产管理-数据监测
     */
    @Override
    public ProDatmon selectProDatmonById(Long damonId)
    {
        return proDatmonMapper.selectProDatmonById(damonId);
    }

    /**
     * 查询生产管理-数据监测列表
     * 
     * @param proDatmon 生产管理-数据监测
     * @return 生产管理-数据监测
     */
    @Override
    public List<ProDatmon> selectProDatmonList(ProDatmon proDatmon)
    {
        return proDatmonMapper.selectProDatmonList(proDatmon);
    }

    /**
     * 新增生产管理-数据监测
     * 
     * @param proDatmon 生产管理-数据监测
     * @return 结果
     */
    @Override
    public int insertProDatmon(ProDatmon proDatmon)
    {
        proDatmon.setCreateTime(DateUtils.getNowDate());
        return proDatmonMapper.insertProDatmon(proDatmon);
    }

    /**
     * 修改生产管理-数据监测
     * 
     * @param proDatmon 生产管理-数据监测
     * @return 结果
     */
    @Override
    public int updateProDatmon(ProDatmon proDatmon)
    {
        proDatmon.setUpdateTime(DateUtils.getNowDate());
        return proDatmonMapper.updateProDatmon(proDatmon);
    }

    /**
     * 批量删除生产管理-数据监测
     * 
     * @param damonIds 需要删除的生产管理-数据监测ID
     * @return 结果
     */
    @Override
    public int deleteProDatmonByIds(Long[] damonIds)
    {
        return proDatmonMapper.deleteProDatmonByIds(damonIds);
    }

    /**
     * 删除生产管理-数据监测信息
     * 
     * @param damonId 生产管理-数据监测ID
     * @return 结果
     */
    @Override
    public int deleteProDatmonById(Long damonId)
    {
        return proDatmonMapper.deleteProDatmonById(damonId);
    }
}
