package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.ProEnmonMapper;
import com.ruoyi.project.cmplant.domain.ProEnmon;
import com.ruoyi.project.cmplant.service.IProEnmonService;

/**
 * 生产管理-环境监测Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class ProEnmonServiceImpl implements IProEnmonService 
{
    @Autowired
    private ProEnmonMapper proEnmonMapper;

    /**
     * 查询生产管理-环境监测
     * 
     * @param enmonId 生产管理-环境监测ID
     * @return 生产管理-环境监测
     */
    @Override
    public ProEnmon selectProEnmonById(Long enmonId)
    {
        return proEnmonMapper.selectProEnmonById(enmonId);
    }

    /**
     * 查询生产管理-环境监测列表
     * 
     * @param proEnmon 生产管理-环境监测
     * @return 生产管理-环境监测
     */
    @Override
    public List<ProEnmon> selectProEnmonList(ProEnmon proEnmon)
    {
        return proEnmonMapper.selectProEnmonList(proEnmon);
    }

    /**
     * 新增生产管理-环境监测
     * 
     * @param proEnmon 生产管理-环境监测
     * @return 结果
     */
    @Override
    public int insertProEnmon(ProEnmon proEnmon)
    {
        proEnmon.setCreateTime(DateUtils.getNowDate());
        return proEnmonMapper.insertProEnmon(proEnmon);
    }

    /**
     * 修改生产管理-环境监测
     * 
     * @param proEnmon 生产管理-环境监测
     * @return 结果
     */
    @Override
    public int updateProEnmon(ProEnmon proEnmon)
    {
        proEnmon.setUpdateTime(DateUtils.getNowDate());
        return proEnmonMapper.updateProEnmon(proEnmon);
    }

    /**
     * 批量删除生产管理-环境监测
     * 
     * @param enmonIds 需要删除的生产管理-环境监测ID
     * @return 结果
     */
    @Override
    public int deleteProEnmonByIds(Long[] enmonIds)
    {
        return proEnmonMapper.deleteProEnmonByIds(enmonIds);
    }

    /**
     * 删除生产管理-环境监测信息
     * 
     * @param enmonId 生产管理-环境监测ID
     * @return 结果
     */
    @Override
    public int deleteProEnmonById(Long enmonId)
    {
        return proEnmonMapper.deleteProEnmonById(enmonId);
    }
}
