package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.ProPurMapper;
import com.ruoyi.project.cmplant.domain.ProPur;
import com.ruoyi.project.cmplant.service.IProPurService;

/**
 * 生产管理-采购订单Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class ProPurServiceImpl implements IProPurService 
{
    @Autowired
    private ProPurMapper proPurMapper;

    /**
     * 查询生产管理-采购订单
     * 
     * @param purId 生产管理-采购订单ID
     * @return 生产管理-采购订单
     */
    @Override
    public ProPur selectProPurById(Long purId)
    {
        return proPurMapper.selectProPurById(purId);
    }

    /**
     * 查询生产管理-采购订单列表
     * 
     * @param proPur 生产管理-采购订单
     * @return 生产管理-采购订单
     */
    @Override
    public List<ProPur> selectProPurList(ProPur proPur)
    {
        return proPurMapper.selectProPurList(proPur);
    }

    /**
     * 新增生产管理-采购订单
     * 
     * @param proPur 生产管理-采购订单
     * @return 结果
     */
    @Override
    public int insertProPur(ProPur proPur)
    {
        proPur.setCreateTime(DateUtils.getNowDate());
        return proPurMapper.insertProPur(proPur);
    }

    /**
     * 修改生产管理-采购订单
     * 
     * @param proPur 生产管理-采购订单
     * @return 结果
     */
    @Override
    public int updateProPur(ProPur proPur)
    {
        proPur.setUpdateTime(DateUtils.getNowDate());
        return proPurMapper.updateProPur(proPur);
    }

    /**
     * 批量删除生产管理-采购订单
     * 
     * @param purIds 需要删除的生产管理-采购订单ID
     * @return 结果
     */
    @Override
    public int deleteProPurByIds(Long[] purIds)
    {
        return proPurMapper.deleteProPurByIds(purIds);
    }

    /**
     * 删除生产管理-采购订单信息
     * 
     * @param purId 生产管理-采购订单ID
     * @return 结果
     */
    @Override
    public int deleteProPurById(Long purId)
    {
        return proPurMapper.deleteProPurById(purId);
    }
}
