package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.ProSalesMapper;
import com.ruoyi.project.cmplant.domain.ProSales;
import com.ruoyi.project.cmplant.service.IProSalesService;

/**
 * 生产管理-销售订单Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class ProSalesServiceImpl implements IProSalesService 
{
    @Autowired
    private ProSalesMapper proSalesMapper;

    /**
     * 查询生产管理-销售订单
     * 
     * @param salesId 生产管理-销售订单ID
     * @return 生产管理-销售订单
     */
    @Override
    public ProSales selectProSalesById(Long salesId)
    {
        return proSalesMapper.selectProSalesById(salesId);
    }

    /**
     * 查询生产管理-销售订单列表
     * 
     * @param proSales 生产管理-销售订单
     * @return 生产管理-销售订单
     */
    @Override
    public List<ProSales> selectProSalesList(ProSales proSales)
    {
        return proSalesMapper.selectProSalesList(proSales);
    }

    /**
     * 新增生产管理-销售订单
     * 
     * @param proSales 生产管理-销售订单
     * @return 结果
     */
    @Override
    public int insertProSales(ProSales proSales)
    {
        proSales.setCreateTime(DateUtils.getNowDate());
        return proSalesMapper.insertProSales(proSales);
    }

    /**
     * 修改生产管理-销售订单
     * 
     * @param proSales 生产管理-销售订单
     * @return 结果
     */
    @Override
    public int updateProSales(ProSales proSales)
    {
        proSales.setUpdateTime(DateUtils.getNowDate());
        return proSalesMapper.updateProSales(proSales);
    }

    /**
     * 批量删除生产管理-销售订单
     * 
     * @param salesIds 需要删除的生产管理-销售订单ID
     * @return 结果
     */
    @Override
    public int deleteProSalesByIds(Long[] salesIds)
    {
        return proSalesMapper.deleteProSalesByIds(salesIds);
    }

    /**
     * 删除生产管理-销售订单信息
     * 
     * @param salesId 生产管理-销售订单ID
     * @return 结果
     */
    @Override
    public int deleteProSalesById(Long salesId)
    {
        return proSalesMapper.deleteProSalesById(salesId);
    }
}
