package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.ProductionSjglMapper;
import com.ruoyi.project.cmplant.domain.ProductionSjgl;
import com.ruoyi.project.cmplant.service.IProductionSjglService;

/**
 * 试验管理-试件管理Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class ProductionSjglServiceImpl implements IProductionSjglService 
{
    @Autowired
    private ProductionSjglMapper productionSjglMapper;

    /**
     * 查询试验管理-试件管理
     * 
     * @param sjglId 试验管理-试件管理ID
     * @return 试验管理-试件管理
     */
    @Override
    public ProductionSjgl selectProductionSjglById(Long sjglId)
    {
        return productionSjglMapper.selectProductionSjglById(sjglId);
    }

    /**
     * 查询试验管理-试件管理列表
     * 
     * @param productionSjgl 试验管理-试件管理
     * @return 试验管理-试件管理
     */
    @Override
    public List<ProductionSjgl> selectProductionSjglList(ProductionSjgl productionSjgl)
    {
        return productionSjglMapper.selectProductionSjglList(productionSjgl);
    }

    /**
     * 新增试验管理-试件管理
     * 
     * @param productionSjgl 试验管理-试件管理
     * @return 结果
     */
    @Override
    public int insertProductionSjgl(ProductionSjgl productionSjgl)
    {
        productionSjgl.setCreateTime(DateUtils.getNowDate());
        return productionSjglMapper.insertProductionSjgl(productionSjgl);
    }

    /**
     * 修改试验管理-试件管理
     * 
     * @param productionSjgl 试验管理-试件管理
     * @return 结果
     */
    @Override
    public int updateProductionSjgl(ProductionSjgl productionSjgl)
    {
        productionSjgl.setUpdateTime(DateUtils.getNowDate());
        return productionSjglMapper.updateProductionSjgl(productionSjgl);
    }

    /**
     * 批量删除试验管理-试件管理
     * 
     * @param sjglIds 需要删除的试验管理-试件管理ID
     * @return 结果
     */
    @Override
    public int deleteProductionSjglByIds(Long[] sjglIds)
    {
        return productionSjglMapper.deleteProductionSjglByIds(sjglIds);
    }

    /**
     * 删除试验管理-试件管理信息
     * 
     * @param sjglId 试验管理-试件管理ID
     * @return 结果
     */
    @Override
    public int deleteProductionSjglById(Long sjglId)
    {
        return productionSjglMapper.deleteProductionSjglById(sjglId);
    }
}
