package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.ProductionSyMapper;
import com.ruoyi.project.cmplant.domain.ProductionSy;
import com.ruoyi.project.cmplant.service.IProductionSyService;

/**
 * 试验管理-溯源Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class ProductionSyServiceImpl implements IProductionSyService 
{
    @Autowired
    private ProductionSyMapper productionSyMapper;

    /**
     * 查询试验管理-溯源
     * 
     * @param syId 试验管理-溯源ID
     * @return 试验管理-溯源
     */
    @Override
    public ProductionSy selectProductionSyById(Long syId)
    {
        return productionSyMapper.selectProductionSyById(syId);
    }

    /**
     * 查询试验管理-溯源列表
     * 
     * @param productionSy 试验管理-溯源
     * @return 试验管理-溯源
     */
    @Override
    public List<ProductionSy> selectProductionSyList(ProductionSy productionSy)
    {
        return productionSyMapper.selectProductionSyList(productionSy);
    }

    /**
     * 新增试验管理-溯源
     * 
     * @param productionSy 试验管理-溯源
     * @return 结果
     */
    @Override
    public int insertProductionSy(ProductionSy productionSy)
    {
        productionSy.setCreateTime(DateUtils.getNowDate());
        return productionSyMapper.insertProductionSy(productionSy);
    }

    /**
     * 修改试验管理-溯源
     * 
     * @param productionSy 试验管理-溯源
     * @return 结果
     */
    @Override
    public int updateProductionSy(ProductionSy productionSy)
    {
        productionSy.setUpdateTime(DateUtils.getNowDate());
        return productionSyMapper.updateProductionSy(productionSy);
    }

    /**
     * 批量删除试验管理-溯源
     * 
     * @param syIds 需要删除的试验管理-溯源ID
     * @return 结果
     */
    @Override
    public int deleteProductionSyByIds(Long[] syIds)
    {
        return productionSyMapper.deleteProductionSyByIds(syIds);
    }

    /**
     * 删除试验管理-溯源信息
     * 
     * @param syId 试验管理-溯源ID
     * @return 结果
     */
    @Override
    public int deleteProductionSyById(Long syId)
    {
        return productionSyMapper.deleteProductionSyById(syId);
    }
}
