package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.ProductionSyjlMapper;
import com.ruoyi.project.cmplant.domain.ProductionSyjl;
import com.ruoyi.project.cmplant.service.IProductionSyjlService;

/**
 * 试验管理-试验记录Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class ProductionSyjlServiceImpl implements IProductionSyjlService 
{
    @Autowired
    private ProductionSyjlMapper productionSyjlMapper;

    /**
     * 查询试验管理-试验记录
     * 
     * @param syjlId 试验管理-试验记录ID
     * @return 试验管理-试验记录
     */
    @Override
    public ProductionSyjl selectProductionSyjlById(Long syjlId)
    {
        return productionSyjlMapper.selectProductionSyjlById(syjlId);
    }

    /**
     * 查询试验管理-试验记录列表
     * 
     * @param productionSyjl 试验管理-试验记录
     * @return 试验管理-试验记录
     */
    @Override
    public List<ProductionSyjl> selectProductionSyjlList(ProductionSyjl productionSyjl)
    {
        return productionSyjlMapper.selectProductionSyjlList(productionSyjl);
    }

    /**
     * 新增试验管理-试验记录
     * 
     * @param productionSyjl 试验管理-试验记录
     * @return 结果
     */
    @Override
    public int insertProductionSyjl(ProductionSyjl productionSyjl)
    {
        productionSyjl.setCreateTime(DateUtils.getNowDate());
        return productionSyjlMapper.insertProductionSyjl(productionSyjl);
    }

    /**
     * 修改试验管理-试验记录
     * 
     * @param productionSyjl 试验管理-试验记录
     * @return 结果
     */
    @Override
    public int updateProductionSyjl(ProductionSyjl productionSyjl)
    {
        productionSyjl.setUpdateTime(DateUtils.getNowDate());
        return productionSyjlMapper.updateProductionSyjl(productionSyjl);
    }

    /**
     * 批量删除试验管理-试验记录
     * 
     * @param syjlIds 需要删除的试验管理-试验记录ID
     * @return 结果
     */
    @Override
    public int deleteProductionSyjlByIds(Long[] syjlIds)
    {
        return productionSyjlMapper.deleteProductionSyjlByIds(syjlIds);
    }

    /**
     * 删除试验管理-试验记录信息
     * 
     * @param syjlId 试验管理-试验记录ID
     * @return 结果
     */
    @Override
    public int deleteProductionSyjlById(Long syjlId)
    {
        return productionSyjlMapper.deleteProductionSyjlById(syjlId);
    }
}
