package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.TransportYsjcMapper;
import com.ruoyi.project.cmplant.domain.TransportYsjc;
import com.ruoyi.project.cmplant.service.ITransportYsjcService;

/**
 * 运输管理-运输记录Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class TransportYsjcServiceImpl implements ITransportYsjcService 
{
    @Autowired
    private TransportYsjcMapper transportYsjcMapper;

    /**
     * 查询运输管理-运输记录
     * 
     * @param ysjlId 运输管理-运输记录ID
     * @return 运输管理-运输记录
     */
    @Override
    public TransportYsjc selectTransportYsjcById(Long ysjlId)
    {
        return transportYsjcMapper.selectTransportYsjcById(ysjlId);
    }

    /**
     * 查询运输管理-运输记录列表
     * 
     * @param transportYsjc 运输管理-运输记录
     * @return 运输管理-运输记录
     */
    @Override
    public List<TransportYsjc> selectTransportYsjcList(TransportYsjc transportYsjc)
    {
        return transportYsjcMapper.selectTransportYsjcList(transportYsjc);
    }

    /**
     * 新增运输管理-运输记录
     * 
     * @param transportYsjc 运输管理-运输记录
     * @return 结果
     */
    @Override
    public int insertTransportYsjc(TransportYsjc transportYsjc)
    {
        transportYsjc.setCreateTime(DateUtils.getNowDate());
        return transportYsjcMapper.insertTransportYsjc(transportYsjc);
    }

    /**
     * 修改运输管理-运输记录
     * 
     * @param transportYsjc 运输管理-运输记录
     * @return 结果
     */
    @Override
    public int updateTransportYsjc(TransportYsjc transportYsjc)
    {
        transportYsjc.setUpdateTime(DateUtils.getNowDate());
        return transportYsjcMapper.updateTransportYsjc(transportYsjc);
    }

    /**
     * 批量删除运输管理-运输记录
     * 
     * @param ysjlIds 需要删除的运输管理-运输记录ID
     * @return 结果
     */
    @Override
    public int deleteTransportYsjcByIds(Long[] ysjlIds)
    {
        return transportYsjcMapper.deleteTransportYsjcByIds(ysjlIds);
    }

    /**
     * 删除运输管理-运输记录信息
     * 
     * @param ysjlId 运输管理-运输记录ID
     * @return 结果
     */
    @Override
    public int deleteTransportYsjcById(Long ysjlId)
    {
        return transportYsjcMapper.deleteTransportYsjcById(ysjlId);
    }
}
