package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.TransportYslxszMapper;
import com.ruoyi.project.cmplant.domain.TransportYslxsz;
import com.ruoyi.project.cmplant.service.ITransportYslxszService;

/**
 * 运输管理-运输路线设置Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class TransportYslxszServiceImpl implements ITransportYslxszService 
{
    @Autowired
    private TransportYslxszMapper transportYslxszMapper;

    /**
     * 查询运输管理-运输路线设置
     * 
     * @param yslxszId 运输管理-运输路线设置ID
     * @return 运输管理-运输路线设置
     */
    @Override
    public TransportYslxsz selectTransportYslxszById(Long yslxszId)
    {
        return transportYslxszMapper.selectTransportYslxszById(yslxszId);
    }

    /**
     * 查询运输管理-运输路线设置列表
     * 
     * @param transportYslxsz 运输管理-运输路线设置
     * @return 运输管理-运输路线设置
     */
    @Override
    public List<TransportYslxsz> selectTransportYslxszList(TransportYslxsz transportYslxsz)
    {
        return transportYslxszMapper.selectTransportYslxszList(transportYslxsz);
    }

    /**
     * 新增运输管理-运输路线设置
     * 
     * @param transportYslxsz 运输管理-运输路线设置
     * @return 结果
     */
    @Override
    public int insertTransportYslxsz(TransportYslxsz transportYslxsz)
    {
        transportYslxsz.setCreateTime(DateUtils.getNowDate());
        return transportYslxszMapper.insertTransportYslxsz(transportYslxsz);
    }

    /**
     * 修改运输管理-运输路线设置
     * 
     * @param transportYslxsz 运输管理-运输路线设置
     * @return 结果
     */
    @Override
    public int updateTransportYslxsz(TransportYslxsz transportYslxsz)
    {
        transportYslxsz.setUpdateTime(DateUtils.getNowDate());
        return transportYslxszMapper.updateTransportYslxsz(transportYslxsz);
    }

    /**
     * 批量删除运输管理-运输路线设置
     * 
     * @param yslxszIds 需要删除的运输管理-运输路线设置ID
     * @return 结果
     */
    @Override
    public int deleteTransportYslxszByIds(Long[] yslxszIds)
    {
        return transportYslxszMapper.deleteTransportYslxszByIds(yslxszIds);
    }

    /**
     * 删除运输管理-运输路线设置信息
     * 
     * @param yslxszId 运输管理-运输路线设置ID
     * @return 结果
     */
    @Override
    public int deleteTransportYslxszById(Long yslxszId)
    {
        return transportYslxszMapper.deleteTransportYslxszById(yslxszId);
    }
}
