package com.ruoyi.project.system.controller;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.constant.UserConstants;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.project.system.domain.SysDept;
import com.ruoyi.project.system.service.ISysDeptService;

/**
 * 部门信息
 * 
 * @author ruoyi
 */
@RestController
@RequestMapping("/system/dept")
public class SysDeptController extends BaseController {
	@Autowired
	private ISysDeptService deptService;

	/**
	 * 获取部门列表
	 */
	// @PreAuthorize("@ss.hasPermi('system:dept:list')")
	@GetMapping("/list")
	public AjaxResult list(SysDept dept) {
		List<SysDept> depts = deptService.selectDeptList(dept);
		return AjaxResult.success(depts);
	}

	@GetMapping("/lists")
	public AjaxResult lists(SysDept dept) {
		List<SysDept> depts1 = deptService.selectDeptList(dept);
		List<SysDept> depts = new ArrayList<SysDept>();
		if (depts1 != null && depts1.size() > 0) {
			for (SysDept sysDept : depts1) {
				depts.add(sysDept);
				if (("1".equals(sysDept.getXzqhjb()) || "2".equals(sysDept.getXzqhjb()))
						&& !"5".equals(sysDept.getLeader()) && !"6".equals(sysDept.getLeader())) {
					SysDept sss = new SysDept();
					sss.setXzqhbm(sysDept.getXzqhbm());
					sss.setXzqhjb(sysDept.getXzqhjb());
					if ("1".equals(sysDept.getXzqhjb())) {
						sss.setDeptName("省直");
					} else {
						sss.setDeptName("市直");
					}

					sss.setDeptId(sysDept.getDeptId());
					sss.setLeader("5");
					depts.add(sss);
				}
			}
		}
		return AjaxResult.success(depts);
	}

	/**
	 * 获取统计数据
	 */
	// @PreAuthorize("@ss.hasPermi('system:dept:list')")
	@GetMapping("/tlist")
	public AjaxResult tlist(SysDept dept) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
		String tbsj = null;
		if (dept.getSj() != null) {
			tbsj = sdf.format(dept.getSj());
		}
		Object xzqhbmObj = dept.getXzqhbm();
		if (xzqhbmObj != null && xzqhbmObj.toString().length() == 12) {
			String xzqhbm = xzqhbmObj.toString();
			if ("0000".equals(xzqhbm.substring(2, 6))) {
				// 查省数据
				dept.setXzqhbm(xzqhbm.substring(0, 1));
			} else if ("00".equals(xzqhbm.substring(4, 6))) {
				// 查市的数据
				dept.setXzqhbm(xzqhbm.substring(0, 4));
			} else if ("000".equals(xzqhbm.substring(6, 9))) {
				// 查县的数据
				dept.setXzqhbm(xzqhbm.substring(0, 6));
			} else if ("000".equals(xzqhbm.substring(9, 12))) {
				// 查镇的数据
				dept.setXzqhbm(xzqhbm.substring(0, 9));
			}

		}
		dept.setTbsj(tbsj);
		List<SysDept> depts = deptService.selectTList(dept);
		return AjaxResult.success(deptService.buildDeptTree(depts));
	}

	/**
	 * 根据部门编号获取详细信息
	 */
	// @PreAuthorize("@ss.hasPermi('system:dept:query')")
	@GetMapping(value = "/{deptId}")
	public AjaxResult getInfo(@PathVariable Long deptId) {
		return AjaxResult.success(deptService.selectDeptById(deptId));
	}

	/**
	 * 获取部门下拉树列表
	 */
	@GetMapping("/treeselect")
	public AjaxResult treeselect(SysDept dept) {
		List<SysDept> depts = deptService.selectDeptList(dept);
		return AjaxResult.success(deptService.buildDeptTreeSelect(depts));
	}

	/**
	 * 加载对应角色部门列表树
	 */
	@GetMapping(value = "/roleDeptTreeselect/{roleId}")
	public AjaxResult roleDeptTreeselect(@PathVariable("roleId") Long roleId) {
		List<SysDept> depts = deptService.selectDeptList(new SysDept());
		AjaxResult ajax = AjaxResult.success();
		ajax.put("checkedKeys", deptService.selectDeptListByRoleId(roleId));
		ajax.put("depts", deptService.buildDeptTreeSelect(depts));
		return ajax;
	}

	/**
	 * 新增部门
	 */
	// @PreAuthorize("@ss.hasPermi('system:dept:add')")
	@Log(title = "部门管理", businessType = BusinessType.INSERT)
	@PostMapping
	public AjaxResult add(@Validated @RequestBody SysDept dept) {

		if (UserConstants.NOT_UNIQUE.equals(deptService.checkDeptNameUnique(dept))) {
			return AjaxResult.error("新增部门'" + dept.getDeptName() + "'失败，部门名称已存在");
		}
		dept.setCreateBy(SecurityUtils.getUsername());

		return toAjax(deptService.insertDept(dept));
	}

	/**
	 * 新增部门
	 */
	// @PreAuthorize("@ss.hasPermi('system:dept:add')")
	@Log(title = "部门管理", businessType = BusinessType.INSERT)
	@PostMapping("/adds")
	public AjaxResult adds(@Validated @RequestBody List<SysDept> depts) {
		if (depts != null && depts.size() > 0) {
			for (SysDept dept : depts) {

				if (UserConstants.NOT_UNIQUE.equals(deptService.checkDeptNameUnique(dept))) {
					return AjaxResult.error("新增部门'" + dept.getDeptName() + "'失败，部门名称已存在");
				}
				dept.setCreateBy(SecurityUtils.getUsername());
				deptService.insertDept(dept);
			}
		}
		return toAjax(1);
	}

	/**
	 * 修改部门
	 */
	// @PreAuthorize("@ss.hasPermi('system:dept:edit')")
	@Log(title = "部门管理", businessType = BusinessType.UPDATE)
	@PutMapping
	public AjaxResult edit(@Validated @RequestBody SysDept dept) {

		if (UserConstants.NOT_UNIQUE.equals(deptService.checkDeptNameUnique(dept))) {
			return AjaxResult.error("修改部门'" + dept.getDeptName() + "'失败，部门名称已存在");
		} else if (dept.getParentId().equals(dept.getDeptId())) {
			return AjaxResult.error("修改部门'" + dept.getDeptName() + "'失败，上级部门不能是自己");
		}
		dept.setUpdateBy(SecurityUtils.getUsername());

		return toAjax(deptService.updateDept(dept));
	}

	/**
	 * 修改部门
	 */
	// @PreAuthorize("@ss.hasPermi('system:dept:edit')")
	@Log(title = "部门管理", businessType = BusinessType.UPDATE)
	@PutMapping("/edits")
	public AjaxResult edits(@Validated @RequestBody List<SysDept> depts) {
		if (depts != null && depts.size() > 0) {
			for (SysDept dept : depts) {

				if (UserConstants.NOT_UNIQUE.equals(deptService.checkDeptNameUnique(dept))) {
					return AjaxResult.error("修改部门'" + dept.getDeptName() + "'失败，部门名称已存在");
				} else if (dept.getParentId().equals(dept.getDeptId())) {
					return AjaxResult.error("修改部门'" + dept.getDeptName() + "'失败，上级部门不能是自己");
				}
				dept.setUpdateBy(SecurityUtils.getUsername());
				deptService.updateDept(dept);
			}
		}
		return toAjax(1);
	}

	/**
	 * 删除部门
	 */
	// @PreAuthorize("@ss.hasPermi('system:dept:remove')")
	@Log(title = "部门管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{deptId}")
	public AjaxResult remove(@PathVariable Long deptId) {
		if (deptService.hasChildByDeptId(deptId)) {
			return AjaxResult.error("存在下级部门,不允许删除");
		}
		if (deptService.checkDeptExistUser(deptId)) {
			return AjaxResult.error("部门存在用户,不允许删除");
		}
		return toAjax(deptService.deleteDeptById(deptId));
	}
}
