package com.ruoyi.project.system.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.system.domain.SysXzqhbm;
import com.ruoyi.project.system.service.ISysXzqhbmService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 行政区划编码Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/system/xzqhbm")
public class SysXzqhbmController extends BaseController
{
    @Autowired
    private ISysXzqhbmService sysXzqhbmService;

    /**
     * 查询行政区划编码列表
     */
    @PreAuthorize("@ss.hasPermi('system:xzqhbm:list')")
    @GetMapping("/list")
    public TableDataInfo list(SysXzqhbm sysXzqhbm)
    {
        startPage();
        List<SysXzqhbm> list = sysXzqhbmService.selectSysXzqhbmList(sysXzqhbm);
        return getDataTable(list);
    }

    /**
     * 导出行政区划编码列表
     */
    @PreAuthorize("@ss.hasPermi('system:xzqhbm:export')")
    @Log(title = "行政区划编码", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(SysXzqhbm sysXzqhbm)
    {
        List<SysXzqhbm> list = sysXzqhbmService.selectSysXzqhbmList(sysXzqhbm);
        ExcelUtil<SysXzqhbm> util = new ExcelUtil<SysXzqhbm>(SysXzqhbm.class);
        return util.exportExcel(list, "xzqhbm");
    }

    /**
     * 获取行政区划编码详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:xzqhbm:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(sysXzqhbmService.selectSysXzqhbmById(id));
    }

    /**
     * 新增行政区划编码
     */
    @PreAuthorize("@ss.hasPermi('system:xzqhbm:add')")
    @Log(title = "行政区划编码", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysXzqhbm sysXzqhbm)
    {
        return toAjax(sysXzqhbmService.insertSysXzqhbm(sysXzqhbm));
    }

    /**
     * 修改行政区划编码
     */
    @PreAuthorize("@ss.hasPermi('system:xzqhbm:edit')")
    @Log(title = "行政区划编码", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysXzqhbm sysXzqhbm)
    {
        return toAjax(sysXzqhbmService.updateSysXzqhbm(sysXzqhbm));
    }

    /**
     * 删除行政区划编码
     */
    @PreAuthorize("@ss.hasPermi('system:xzqhbm:remove')")
    @Log(title = "行政区划编码", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sysXzqhbmService.deleteSysXzqhbmByIds(ids));
    }
}
