package com.ruoyi.project.system.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.system.mapper.SysXzqhbmMapper;
import com.ruoyi.project.system.domain.SysXzqhbm;
import com.ruoyi.project.system.service.ISysXzqhbmService;

/**
 * 行政区划编码Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class SysXzqhbmServiceImpl implements ISysXzqhbmService 
{
    @Autowired
    private SysXzqhbmMapper sysXzqhbmMapper;

    /**
     * 查询行政区划编码
     * 
     * @param id 行政区划编码ID
     * @return 行政区划编码
     */
    @Override
    public SysXzqhbm selectSysXzqhbmById(Long id)
    {
        return sysXzqhbmMapper.selectSysXzqhbmById(id);
    }

    /**
     * 查询行政区划编码列表
     * 
     * @param sysXzqhbm 行政区划编码
     * @return 行政区划编码
     */
    @Override
    public List<SysXzqhbm> selectSysXzqhbmList(SysXzqhbm sysXzqhbm)
    {
        return sysXzqhbmMapper.selectSysXzqhbmList(sysXzqhbm);
    }

    /**
     * 新增行政区划编码
     * 
     * @param sysXzqhbm 行政区划编码
     * @return 结果
     */
    @Override
    public int insertSysXzqhbm(SysXzqhbm sysXzqhbm)
    {
        sysXzqhbm.setCreateTime(DateUtils.getNowDate());
        return sysXzqhbmMapper.insertSysXzqhbm(sysXzqhbm);
    }

    /**
     * 修改行政区划编码
     * 
     * @param sysXzqhbm 行政区划编码
     * @return 结果
     */
    @Override
    public int updateSysXzqhbm(SysXzqhbm sysXzqhbm)
    {
        sysXzqhbm.setUpdateTime(DateUtils.getNowDate());
        return sysXzqhbmMapper.updateSysXzqhbm(sysXzqhbm);
    }

    /**
     * 批量删除行政区划编码
     * 
     * @param ids 需要删除的行政区划编码ID
     * @return 结果
     */
    @Override
    public int deleteSysXzqhbmByIds(Long[] ids)
    {
        return sysXzqhbmMapper.deleteSysXzqhbmByIds(ids);
    }

    /**
     * 删除行政区划编码信息
     * 
     * @param id 行政区划编码ID
     * @return 结果
     */
    @Override
    public int deleteSysXzqhbmById(Long id)
    {
        return sysXzqhbmMapper.deleteSysXzqhbmById(id);
    }
}
