package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.BainfoCar;
import com.ruoyi.project.cmplant.service.IBainfoCarService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 基础信息-车辆管理Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/car")
public class BainfoCarController extends BaseController
{
    @Autowired
    private IBainfoCarService bainfoCarService;

    /**
     * 查询基础信息-车辆管理列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:car:list')")
    @GetMapping("/list")
    public TableDataInfo list(BainfoCar bainfoCar)
    {
        startPage();
        List<BainfoCar> list = bainfoCarService.selectBainfoCarList(bainfoCar);
        return getDataTable(list);
    }

    /**
     * 导出基础信息-车辆管理列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:car:export')")
    @Log(title = "基础信息-车辆管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(BainfoCar bainfoCar)
    {
        List<BainfoCar> list = bainfoCarService.selectBainfoCarList(bainfoCar);
        ExcelUtil<BainfoCar> util = new ExcelUtil<BainfoCar>(BainfoCar.class);
        return util.exportExcel(list, "car");
    }

    /**
     * 获取基础信息-车辆管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:car:query')")
    @GetMapping(value = "/{carId}")
    public AjaxResult getInfo(@PathVariable("carId") Long carId)
    {
        return AjaxResult.success(bainfoCarService.selectBainfoCarById(carId));
    }

    /**
     * 新增基础信息-车辆管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:car:add')")
    @Log(title = "基础信息-车辆管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BainfoCar bainfoCar)
    {
        return toAjax(bainfoCarService.insertBainfoCar(bainfoCar));
    }

    /**
     * 修改基础信息-车辆管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:car:edit')")
    @Log(title = "基础信息-车辆管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BainfoCar bainfoCar)
    {
        return toAjax(bainfoCarService.updateBainfoCar(bainfoCar));
    }

    /**
     * 删除基础信息-车辆管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:car:remove')")
    @Log(title = "基础信息-车辆管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{carIds}")
    public AjaxResult remove(@PathVariable Long[] carIds)
    {
        return toAjax(bainfoCarService.deleteBainfoCarByIds(carIds));
    }
}
