package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.BainfoEncert;
import com.ruoyi.project.cmplant.service.IBainfoEncertService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 基础信息-企业资质Controller
 * 
 * @author lihang
 * @date 2020-08-26
 */
@RestController
@RequestMapping("/cmplant/encert")
public class BainfoEncertController extends BaseController
{
    @Autowired
    private IBainfoEncertService bainfoEncertService;

    /**
     * 查询基础信息-企业资质列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:encert:list')")
    @GetMapping("/list")
    public TableDataInfo list(BainfoEncert bainfoEncert)
    {
        startPage();
        List<BainfoEncert> list = bainfoEncertService.selectBainfoEncertList(bainfoEncert);
        return getDataTable(list);
    }

    /**
     * 导出基础信息-企业资质列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:encert:export')")
    @Log(title = "基础信息-企业资质", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(BainfoEncert bainfoEncert)
    {
        List<BainfoEncert> list = bainfoEncertService.selectBainfoEncertList(bainfoEncert);
        ExcelUtil<BainfoEncert> util = new ExcelUtil<BainfoEncert>(BainfoEncert.class);
        return util.exportExcel(list, "encert");
    }

    /**
     * 获取基础信息-企业资质详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:encert:query')")
    @GetMapping(value = "/{encertId}")
    public AjaxResult getInfo(@PathVariable("encertId") Long encertId)
    {
        return AjaxResult.success(bainfoEncertService.selectBainfoEncertById(encertId));
    }

    /**
     * 新增基础信息-企业资质
     */
    @PreAuthorize("@ss.hasPermi('cmplant:encert:add')")
    @Log(title = "基础信息-企业资质", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BainfoEncert bainfoEncert)
    {
        return toAjax(bainfoEncertService.insertBainfoEncert(bainfoEncert));
    }

    /**
     * 修改基础信息-企业资质
     */
    @PreAuthorize("@ss.hasPermi('cmplant:encert:edit')")
    @Log(title = "基础信息-企业资质", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BainfoEncert bainfoEncert)
    {
        return toAjax(bainfoEncertService.updateBainfoEncert(bainfoEncert));
    }

    /**
     * 删除基础信息-企业资质
     */
    @PreAuthorize("@ss.hasPermi('cmplant:encert:remove')")
    @Log(title = "基础信息-企业资质", businessType = BusinessType.DELETE)
	@DeleteMapping("/{encertIds}")
    public AjaxResult remove(@PathVariable Long[] encertIds)
    {
        return toAjax(bainfoEncertService.deleteBainfoEncertByIds(encertIds));
    }
}
