package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.BainfoEninfo;
import com.ruoyi.project.cmplant.service.IBainfoEninfoService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 基础信息-企业信息Controller
 * 
 * @author lihang
 * @date 2020-08-26
 */
@RestController
@RequestMapping("/cmplant/eninfo")
public class BainfoEninfoController extends BaseController
{
    @Autowired
    private IBainfoEninfoService bainfoEninfoService;

    /**
     * 查询基础信息-企业信息列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:eninfo:list')")
    @GetMapping("/list")
    public TableDataInfo list(BainfoEninfo bainfoEninfo)
    {
        startPage();
        List<BainfoEninfo> list = bainfoEninfoService.selectBainfoEninfoList(bainfoEninfo);
        return getDataTable(list);
    }

    /**
     * 导出基础信息-企业信息列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:eninfo:export')")
    @Log(title = "基础信息-企业信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(BainfoEninfo bainfoEninfo)
    {
        List<BainfoEninfo> list = bainfoEninfoService.selectBainfoEninfoList(bainfoEninfo);
        ExcelUtil<BainfoEninfo> util = new ExcelUtil<BainfoEninfo>(BainfoEninfo.class);
        return util.exportExcel(list, "eninfo");
    }

    /**
     * 获取基础信息-企业信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:eninfo:query')")
    @GetMapping(value = "/{eninfoId}")
    public AjaxResult getInfo(@PathVariable("eninfoId") Long eninfoId)
    {
        return AjaxResult.success(bainfoEninfoService.selectBainfoEninfoById(eninfoId));
    }

    /**
     * 新增基础信息-企业信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:eninfo:add')")
    @Log(title = "基础信息-企业信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BainfoEninfo bainfoEninfo)
    {
        return toAjax(bainfoEninfoService.insertBainfoEninfo(bainfoEninfo));
    }

    /**
     * 修改基础信息-企业信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:eninfo:edit')")
    @Log(title = "基础信息-企业信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BainfoEninfo bainfoEninfo)
    {
        return toAjax(bainfoEninfoService.updateBainfoEninfo(bainfoEninfo));
    }

    /**
     * 删除基础信息-企业信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:eninfo:remove')")
    @Log(title = "基础信息-企业信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{eninfoIds}")
    public AjaxResult remove(@PathVariable Long[] eninfoIds)
    {
        return toAjax(bainfoEninfoService.deleteBainfoEninfoByIds(eninfoIds));
    }
}
