package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.ProPurPdet;
import com.ruoyi.project.cmplant.service.IProPurPdetService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 生产管理-采购订单-采购明细Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/pdet")
public class ProPurPdetController extends BaseController
{
    @Autowired
    private IProPurPdetService proPurPdetService;

    /**
     * 查询生产管理-采购订单-采购明细列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:pdet:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProPurPdet proPurPdet)
    {
        startPage();
        List<ProPurPdet> list = proPurPdetService.selectProPurPdetList(proPurPdet);
        return getDataTable(list);
    }

    /**
     * 导出生产管理-采购订单-采购明细列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:pdet:export')")
    @Log(title = "生产管理-采购订单-采购明细", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(ProPurPdet proPurPdet)
    {
        List<ProPurPdet> list = proPurPdetService.selectProPurPdetList(proPurPdet);
        ExcelUtil<ProPurPdet> util = new ExcelUtil<ProPurPdet>(ProPurPdet.class);
        return util.exportExcel(list, "pdet");
    }

    /**
     * 获取生产管理-采购订单-采购明细详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:pdet:query')")
    @GetMapping(value = "/{pdetId}")
    public AjaxResult getInfo(@PathVariable("pdetId") Long pdetId)
    {
        return AjaxResult.success(proPurPdetService.selectProPurPdetById(pdetId));
    }

    /**
     * 新增生产管理-采购订单-采购明细
     */
    @PreAuthorize("@ss.hasPermi('cmplant:pdet:add')")
    @Log(title = "生产管理-采购订单-采购明细", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProPurPdet proPurPdet)
    {
        return toAjax(proPurPdetService.insertProPurPdet(proPurPdet));
    }

    /**
     * 修改生产管理-采购订单-采购明细
     */
    @PreAuthorize("@ss.hasPermi('cmplant:pdet:edit')")
    @Log(title = "生产管理-采购订单-采购明细", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProPurPdet proPurPdet)
    {
        return toAjax(proPurPdetService.updateProPurPdet(proPurPdet));
    }

    /**
     * 删除生产管理-采购订单-采购明细
     */
    @PreAuthorize("@ss.hasPermi('cmplant:pdet:remove')")
    @Log(title = "生产管理-采购订单-采购明细", businessType = BusinessType.DELETE)
	@DeleteMapping("/{pdetIds}")
    public AjaxResult remove(@PathVariable Long[] pdetIds)
    {
        return toAjax(proPurPdetService.deleteProPurPdetByIds(pdetIds));
    }
}
