package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.ProStatis;
import com.ruoyi.project.cmplant.service.IProStatisService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 生产管理-生产统计Controller
 * 
 * @author lihang
 * @date 2020-08-28
 */
@RestController
@RequestMapping("/cmplant/statis")
public class ProStatisController extends BaseController
{
    @Autowired
    private IProStatisService proStatisService;

    /**
     * 查询生产管理-生产统计列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:statis:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProStatis proStatis)
    {
        startPage();
        List<ProStatis> list = proStatisService.selectProStatisList(proStatis);
        return getDataTable(list);
    }

    /**
     * 导出生产管理-生产统计列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:statis:export')")
    @Log(title = "生产管理-生产统计", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(ProStatis proStatis)
    {
        List<ProStatis> list = proStatisService.selectProStatisList(proStatis);
        ExcelUtil<ProStatis> util = new ExcelUtil<ProStatis>(ProStatis.class);
        return util.exportExcel(list, "statis");
    }

    /**
     * 获取生产管理-生产统计详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:statis:query')")
    @GetMapping(value = "/{statisId}")
    public AjaxResult getInfo(@PathVariable("statisId") Long statisId)
    {
        return AjaxResult.success(proStatisService.selectProStatisById(statisId));
    }

    /**
     * 新增生产管理-生产统计
     */
    @PreAuthorize("@ss.hasPermi('cmplant:statis:add')")
    @Log(title = "生产管理-生产统计", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProStatis proStatis)
    {
        return toAjax(proStatisService.insertProStatis(proStatis));
    }

    /**
     * 修改生产管理-生产统计
     */
    @PreAuthorize("@ss.hasPermi('cmplant:statis:edit')")
    @Log(title = "生产管理-生产统计", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProStatis proStatis)
    {
        return toAjax(proStatisService.updateProStatis(proStatis));
    }

    /**
     * 删除生产管理-生产统计
     */
    @PreAuthorize("@ss.hasPermi('cmplant:statis:remove')")
    @Log(title = "生产管理-生产统计", businessType = BusinessType.DELETE)
	@DeleteMapping("/{statisIds}")
    public AjaxResult remove(@PathVariable Long[] statisIds)
    {
        return toAjax(proStatisService.deleteProStatisByIds(statisIds));
    }
}
