package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.TransportYsjc;
import com.ruoyi.project.cmplant.service.ITransportYsjcService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 运输管理-运输记录Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/ysjc")
public class TransportYsjcController extends BaseController
{
    @Autowired
    private ITransportYsjcService transportYsjcService;

    /**
     * 查询运输管理-运输记录列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ysjc:list')")
    @GetMapping("/list")
    public TableDataInfo list(TransportYsjc transportYsjc)
    {
        startPage();
        List<TransportYsjc> list = transportYsjcService.selectTransportYsjcList(transportYsjc);
        return getDataTable(list);
    }

    /**
     * 导出运输管理-运输记录列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ysjc:export')")
    @Log(title = "运输管理-运输记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TransportYsjc transportYsjc)
    {
        List<TransportYsjc> list = transportYsjcService.selectTransportYsjcList(transportYsjc);
        ExcelUtil<TransportYsjc> util = new ExcelUtil<TransportYsjc>(TransportYsjc.class);
        return util.exportExcel(list, "ysjc");
    }

    /**
     * 获取运输管理-运输记录详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ysjc:query')")
    @GetMapping(value = "/{ysjlId}")
    public AjaxResult getInfo(@PathVariable("ysjlId") Long ysjlId)
    {
        return AjaxResult.success(transportYsjcService.selectTransportYsjcById(ysjlId));
    }

    /**
     * 新增运输管理-运输记录
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ysjc:add')")
    @Log(title = "运输管理-运输记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TransportYsjc transportYsjc)
    {
        return toAjax(transportYsjcService.insertTransportYsjc(transportYsjc));
    }

    /**
     * 修改运输管理-运输记录
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ysjc:edit')")
    @Log(title = "运输管理-运输记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TransportYsjc transportYsjc)
    {
        return toAjax(transportYsjcService.updateTransportYsjc(transportYsjc));
    }

    /**
     * 删除运输管理-运输记录
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ysjc:remove')")
    @Log(title = "运输管理-运输记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ysjlIds}")
    public AjaxResult remove(@PathVariable Long[] ysjlIds)
    {
        return toAjax(transportYsjcService.deleteTransportYsjcByIds(ysjlIds));
    }
}
