package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.TransportYstj;
import com.ruoyi.project.cmplant.service.ITransportYstjService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 运输管理-运输统计Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/ystj")
public class TransportYstjController extends BaseController
{
    @Autowired
    private ITransportYstjService transportYstjService;

    /**
     * 查询运输管理-运输统计列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ystj:list')")
    @GetMapping("/list")
    public TableDataInfo list(TransportYstj transportYstj)
    {
        startPage();
        List<TransportYstj> list = transportYstjService.selectTransportYstjList(transportYstj);
        return getDataTable(list);
    }

    /**
     * 导出运输管理-运输统计列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ystj:export')")
    @Log(title = "运输管理-运输统计", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TransportYstj transportYstj)
    {
        List<TransportYstj> list = transportYstjService.selectTransportYstjList(transportYstj);
        ExcelUtil<TransportYstj> util = new ExcelUtil<TransportYstj>(TransportYstj.class);
        return util.exportExcel(list, "ystj");
    }

    /**
     * 获取运输管理-运输统计详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ystj:query')")
    @GetMapping(value = "/{ystjId}")
    public AjaxResult getInfo(@PathVariable("ystjId") Long ystjId)
    {
        return AjaxResult.success(transportYstjService.selectTransportYstjById(ystjId));
    }

    /**
     * 新增运输管理-运输统计
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ystj:add')")
    @Log(title = "运输管理-运输统计", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TransportYstj transportYstj)
    {
        return toAjax(transportYstjService.insertTransportYstj(transportYstj));
    }

    /**
     * 修改运输管理-运输统计
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ystj:edit')")
    @Log(title = "运输管理-运输统计", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TransportYstj transportYstj)
    {
        return toAjax(transportYstjService.updateTransportYstj(transportYstj));
    }

    /**
     * 删除运输管理-运输统计
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ystj:remove')")
    @Log(title = "运输管理-运输统计", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ystjIds}")
    public AjaxResult remove(@PathVariable Long[] ystjIds)
    {
        return toAjax(transportYstjService.deleteTransportYstjByIds(ystjIds));
    }
}
