package com.ruoyi.project.cmplant.service;

import java.util.List;
import com.ruoyi.project.cmplant.domain.BainfoMiplant;

/**
 * 基础信息-搅拌站管理Service接口
 * 
 * @author lihang
 * @date 2020-08-26
 */
public interface IBainfoMiplantService 
{
    /**
     * 查询基础信息-搅拌站管理
     * 
     * @param miplantId 基础信息-搅拌站管理ID
     * @return 基础信息-搅拌站管理
     */
    public BainfoMiplant selectBainfoMiplantById(Long miplantId);

    /**
     * 查询基础信息-搅拌站管理列表
     * 
     * @param bainfoMiplant 基础信息-搅拌站管理
     * @return 基础信息-搅拌站管理集合
     */
    public List<BainfoMiplant> selectBainfoMiplantList(BainfoMiplant bainfoMiplant);

    /**
     * 新增基础信息-搅拌站管理
     * 
     * @param bainfoMiplant 基础信息-搅拌站管理
     * @return 结果
     */
    public int insertBainfoMiplant(BainfoMiplant bainfoMiplant);

    /**
     * 修改基础信息-搅拌站管理
     * 
     * @param bainfoMiplant 基础信息-搅拌站管理
     * @return 结果
     */
    public int updateBainfoMiplant(BainfoMiplant bainfoMiplant);

    /**
     * 批量删除基础信息-搅拌站管理
     * 
     * @param miplantIds 需要删除的基础信息-搅拌站管理ID
     * @return 结果
     */
    public int deleteBainfoMiplantByIds(Long[] miplantIds);

    /**
     * 删除基础信息-搅拌站管理信息
     * 
     * @param miplantId 基础信息-搅拌站管理ID
     * @return 结果
     */
    public int deleteBainfoMiplantById(Long miplantId);
}
