package com.ruoyi.project.cmplant.service;

import java.util.List;
import com.ruoyi.project.cmplant.domain.ProEnmon;

/**
 * 生产管理-环境监测Service接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface IProEnmonService 
{
    /**
     * 查询生产管理-环境监测
     * 
     * @param enmonId 生产管理-环境监测ID
     * @return 生产管理-环境监测
     */
    public ProEnmon selectProEnmonById(Long enmonId);

    /**
     * 查询生产管理-环境监测列表
     * 
     * @param proEnmon 生产管理-环境监测
     * @return 生产管理-环境监测集合
     */
    public List<ProEnmon> selectProEnmonList(ProEnmon proEnmon);

    /**
     * 新增生产管理-环境监测
     * 
     * @param proEnmon 生产管理-环境监测
     * @return 结果
     */
    public int insertProEnmon(ProEnmon proEnmon);

    /**
     * 修改生产管理-环境监测
     * 
     * @param proEnmon 生产管理-环境监测
     * @return 结果
     */
    public int updateProEnmon(ProEnmon proEnmon);

    /**
     * 批量删除生产管理-环境监测
     * 
     * @param enmonIds 需要删除的生产管理-环境监测ID
     * @return 结果
     */
    public int deleteProEnmonByIds(Long[] enmonIds);

    /**
     * 删除生产管理-环境监测信息
     * 
     * @param enmonId 生产管理-环境监测ID
     * @return 结果
     */
    public int deleteProEnmonById(Long enmonId);
}
