package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.BainfoMiplantMapper;
import com.ruoyi.project.cmplant.domain.BainfoMiplant;
import com.ruoyi.project.cmplant.service.IBainfoMiplantService;

/**
 * 基础信息-搅拌站管理Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-26
 */
@Service
public class BainfoMiplantServiceImpl implements IBainfoMiplantService 
{
    @Autowired
    private BainfoMiplantMapper bainfoMiplantMapper;

    /**
     * 查询基础信息-搅拌站管理
     * 
     * @param miplantId 基础信息-搅拌站管理ID
     * @return 基础信息-搅拌站管理
     */
    @Override
    public BainfoMiplant selectBainfoMiplantById(Long miplantId)
    {
        return bainfoMiplantMapper.selectBainfoMiplantById(miplantId);
    }

    /**
     * 查询基础信息-搅拌站管理列表
     * 
     * @param bainfoMiplant 基础信息-搅拌站管理
     * @return 基础信息-搅拌站管理
     */
    @Override
    public List<BainfoMiplant> selectBainfoMiplantList(BainfoMiplant bainfoMiplant)
    {
        return bainfoMiplantMapper.selectBainfoMiplantList(bainfoMiplant);
    }

    /**
     * 新增基础信息-搅拌站管理
     * 
     * @param bainfoMiplant 基础信息-搅拌站管理
     * @return 结果
     */
    @Override
    public int insertBainfoMiplant(BainfoMiplant bainfoMiplant)
    {
        bainfoMiplant.setCreateTime(DateUtils.getNowDate());
        return bainfoMiplantMapper.insertBainfoMiplant(bainfoMiplant);
    }

    /**
     * 修改基础信息-搅拌站管理
     * 
     * @param bainfoMiplant 基础信息-搅拌站管理
     * @return 结果
     */
    @Override
    public int updateBainfoMiplant(BainfoMiplant bainfoMiplant)
    {
        bainfoMiplant.setUpdateTime(DateUtils.getNowDate());
        return bainfoMiplantMapper.updateBainfoMiplant(bainfoMiplant);
    }

    /**
     * 批量删除基础信息-搅拌站管理
     * 
     * @param miplantIds 需要删除的基础信息-搅拌站管理ID
     * @return 结果
     */
    @Override
    public int deleteBainfoMiplantByIds(Long[] miplantIds)
    {
        return bainfoMiplantMapper.deleteBainfoMiplantByIds(miplantIds);
    }

    /**
     * 删除基础信息-搅拌站管理信息
     * 
     * @param miplantId 基础信息-搅拌站管理ID
     * @return 结果
     */
    @Override
    public int deleteBainfoMiplantById(Long miplantId)
    {
        return bainfoMiplantMapper.deleteBainfoMiplantById(miplantId);
    }
}
