package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.TransportYstjMapper;
import com.ruoyi.project.cmplant.domain.TransportYstj;
import com.ruoyi.project.cmplant.service.ITransportYstjService;

/**
 * 运输管理-运输统计Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class TransportYstjServiceImpl implements ITransportYstjService 
{
    @Autowired
    private TransportYstjMapper transportYstjMapper;

    /**
     * 查询运输管理-运输统计
     * 
     * @param ystjId 运输管理-运输统计ID
     * @return 运输管理-运输统计
     */
    @Override
    public TransportYstj selectTransportYstjById(Long ystjId)
    {
        return transportYstjMapper.selectTransportYstjById(ystjId);
    }

    /**
     * 查询运输管理-运输统计列表
     * 
     * @param transportYstj 运输管理-运输统计
     * @return 运输管理-运输统计
     */
    @Override
    public List<TransportYstj> selectTransportYstjList(TransportYstj transportYstj)
    {
        return transportYstjMapper.selectTransportYstjList(transportYstj);
    }

    /**
     * 新增运输管理-运输统计
     * 
     * @param transportYstj 运输管理-运输统计
     * @return 结果
     */
    @Override
    public int insertTransportYstj(TransportYstj transportYstj)
    {
        transportYstj.setCreateTime(DateUtils.getNowDate());
        return transportYstjMapper.insertTransportYstj(transportYstj);
    }

    /**
     * 修改运输管理-运输统计
     * 
     * @param transportYstj 运输管理-运输统计
     * @return 结果
     */
    @Override
    public int updateTransportYstj(TransportYstj transportYstj)
    {
        transportYstj.setUpdateTime(DateUtils.getNowDate());
        return transportYstjMapper.updateTransportYstj(transportYstj);
    }

    /**
     * 批量删除运输管理-运输统计
     * 
     * @param ystjIds 需要删除的运输管理-运输统计ID
     * @return 结果
     */
    @Override
    public int deleteTransportYstjByIds(Long[] ystjIds)
    {
        return transportYstjMapper.deleteTransportYstjByIds(ystjIds);
    }

    /**
     * 删除运输管理-运输统计信息
     * 
     * @param ystjId 运输管理-运输统计ID
     * @return 结果
     */
    @Override
    public int deleteTransportYstjById(Long ystjId)
    {
        return transportYstjMapper.deleteTransportYstjById(ystjId);
    }
}
