package com.ruoyi.project.system.mapper;

import java.util.List;
import com.ruoyi.project.system.domain.SysXzqhbm;

/**
 * 行政区划编码Mapper接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface SysXzqhbmMapper 
{
    /**
     * 查询行政区划编码
     * 
     * @param id 行政区划编码ID
     * @return 行政区划编码
     */
    public SysXzqhbm selectSysXzqhbmById(Long id);

    /**
     * 查询行政区划编码列表
     * 
     * @param sysXzqhbm 行政区划编码
     * @return 行政区划编码集合
     */
    public List<SysXzqhbm> selectSysXzqhbmList(SysXzqhbm sysXzqhbm);

    /**
     * 新增行政区划编码
     * 
     * @param sysXzqhbm 行政区划编码
     * @return 结果
     */
    public int insertSysXzqhbm(SysXzqhbm sysXzqhbm);

    /**
     * 修改行政区划编码
     * 
     * @param sysXzqhbm 行政区划编码
     * @return 结果
     */
    public int updateSysXzqhbm(SysXzqhbm sysXzqhbm);

    /**
     * 删除行政区划编码
     * 
     * @param id 行政区划编码ID
     * @return 结果
     */
    public int deleteSysXzqhbmById(Long id);

    /**
     * 批量删除行政区划编码
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteSysXzqhbmByIds(Long[] ids);
}
