package com.changda.gjjapp.gedai.service.impl.yinhangpikou;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.codehaus.groovy.tools.shell.commands.ShowCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.changda.gjjapp.db.entity.GD_MX;
import com.changda.gjjapp.db.entity.TMP_YW_GDHK_QKMX_WH;
import com.changda.gjjapp.gedai.dao.yinhangpikou.YinHangPiKouCheckDao;
import com.changda.gjjapp.gedai.dao.zhuyuehuakou.ZhuYueHuaKouCheckDao;
import com.changda.gjjapp.gedai.dto.yinhangpikou.YinHangPiKouCompareDto;
import com.changda.gjjapp.gedai.dto.zhuyuehuakou.DrdkQkmxDto;
import com.changda.gjjapp.gedai.dto.zhuyuehuakou.ZhuYueHuakouCompareDto;
import com.changda.gjjapp.gedai.service.yinhangpikou.IYinHangPiKouCheckService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
@Service()
public class YinHangPiKouCheckServiceImpl implements IYinHangPiKouCheckService{

	@Autowired
	private YinHangPiKouCheckDao yinhangpikou;
	
	@Autowired 
	private ZhuYueHuaKouCheckDao ZhuYueHuaKouCheckDao;




	/**
	 * 查询银行批扣，最后显示上面界面
	 */
	@Override
	public Map<String, Object> yhpkData(String kjqj, String zjzxdm, String dkyh, int page, int limit) {
		Map<String, Object> map = new HashMap<>();
		List<YinHangPiKouCompareDto> yhpkData = new ArrayList<>();
		Page<ZhuYueHuakouCompareDto> page2 = PageHelper.startPage(page, limit, true);
		List<Map<String, Object>> dkyhList = yinhangpikou.dkyhData(zjzxdm, dkyh, kjqj); 
		System.out.println(dkyhList.size()+"------------imp");
		int count = (int) page2.getTotal();
		
		for (Map<String, Object> yhpk : dkyhList) {
			YinHangPiKouCompareDto yhpkDto = new YinHangPiKouCompareDto();
			yhpkDto.setZjzxjc(yhpk.get("ZJZXJC").toString());
			yhpkDto.setYhjc(yhpk.get("YHJC").toString());
			yhpkDto.setBJ(Double.parseDouble(yhpk.get("BJ").toString()));
			yhpkDto.setLX(Double.parseDouble(yhpk.get("LX").toString()));
			yhpkDto.setFX(Double.parseDouble(yhpk.get("FX").toString()));
			yhpkDto.setHKJE(Double.parseDouble(yhpk.get("HKJE").toString()));
			yhpkDto.setSYBJ(Double.parseDouble(yhpk.get("SYBJ").toString()));
			yhpkDto.setSYLX(Double.parseDouble(yhpk.get("SYLX").toString()));
			yhpkDto.setSYFX(Double.parseDouble(yhpk.get("SYFX").toString()));
			yhpkDto.setSYHKJE(Double.parseDouble(yhpk.get("SYHKJE").toString()));
			yhpkDto.setJkrxm(yhpk.get("JKRXM").toString());
			yhpkDto.setJkhtbh(yhpk.get("JKHTBH").toString());
			yhpkDto.setJkrzjh(yhpk.get("JKRZJH").toString());
			yhpkDto.setZjzxdm(yhpk.get("ZJZXDM").toString());
			yhpkDto.setGrdkbm(yhpk.get("GRDKBM").toString());
			yhpkDto.setDkyh(yhpk.get("DKYH").toString());
			yhpkData.add(yhpkDto);
		}
		
		map.put("total", count);
		map.put("yhpk", yhpkData);
		return map;
	}


	/**
	 * 查询上月银行批扣金额
	 * @throws ParseException 
	 */
	@Override
	public List<Map<String, Object>> syYinHangPiKouJe(String zjzxdm, String dkyh) throws ParseException {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		//获取本月最后一天作为还款日期
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.DAY_OF_MONTH,
		calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
		SimpleDateFormat lastDay= new SimpleDateFormat("yyyy-MM-dd");
		String last =  lastDay.format(calendar.getTime());
		Date sd = format.parse(last);
		java.sql.Date hkrq=new java.sql.Date(sd.getTime());
		
		
		System.err.println(hkrq);
		List<Map<String, Object>> syyhpkList = yinhangpikou.syYinHangPiKouJe(zjzxdm, dkyh);
		
		return syyhpkList;
	}

	/**
	 * 获取银行上月和本月批扣金额进行比对
	 * @throws ParseException 
	 * @throws IOException 
	 */
	@Override
	public void yinHangPiKouComparison(String zjzxdm, String dkyh, String kjqj,Date HKRQ) throws ParseException, IOException {
		List<TMP_YW_GDHK_QKMX_WH> list = new ArrayList<>();
		List<YinHangPiKouCompareDto> yinHangPiKouList = new ArrayList<>();
		List<Map<String, Object>> syyhpkList = new ArrayList<>();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		//获取本月最后一天作为还款日期
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.DAY_OF_MONTH,
		calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
		SimpleDateFormat lastDay= new SimpleDateFormat("yyyy-MM-dd");
		String last =  lastDay.format(calendar.getTime());
		Date sd = format.parse(last);
		java.sql.Date hkrq=new java.sql.Date(sd.getTime());
		System.err.println(hkrq);
		
		List<Map<String, Object>> grdkbmList = yinhangpikou.yinHangPiKouGrdkbm(zjzxdm, hkrq, dkyh);
		System.out.println(grdkbmList.size()+"个人贷款编码");

		for (int i = 0; i < grdkbmList.size(); i++) {
			Map map1 = new HashMap();
			Map map2 = new HashMap();
			Map map3 = new HashMap();
			Map map4 = new HashMap();
			//个人贷款编码
			String grdkbm = String.valueOf(grdkbmList.get(i).get("GRDKBM"));
			//中心代码
			String zjzxd = ZhuYueHuaKouCheckDao.ZJZXDM(grdkbm);
			map1.put("ZJZXDM", zjzxd);
			map1.put("YYWDDM", null);
			map1.put("TJYHBM", null);
			map1.put("YHBM", null);
			map1.put("ZTBM", null);
			map1.put("HKKXQ", "HKKXQ");
			
			map2.put("ZJZXDM", zjzxd);
			map2.put("YYWDDM", null);
			map2.put("TJYHBM", null);
			map2.put("YHBM", null);
			map2.put("ZTBM", null);
			map2.put("FLLX", "FLLX");
			
			map3.put("ZJZXDM", zjzxd);
			map3.put("YYWDDM", null);
			map3.put("TJYHBM", null);
			map3.put("YHBM", null);
			map3.put("ZTBM", null);
			map3.put("ZNJFX", "ZNJFX");
			
			map4.put("ZJZXDM", zjzxd);
			map4.put("YYWDDM", null);
			map4.put("TJYHBM", null);
			map4.put("YHBM", null);
			map4.put("ZTBM", null);
			map4.put("FXBS", "FXBS");
			
			ZhuYueHuaKouCheckDao.HKKXQ(map1);
			ZhuYueHuaKouCheckDao.FLLX(map2);
			ZhuYueHuaKouCheckDao.ZNJFX(map3);
			ZhuYueHuaKouCheckDao.FXBS(map4);
			
			String HKKXQ =  map1.get("result").toString();
			String FLLX = map2.get("result").toString();
			String ZNJFX =  map3.get("result").toString();
			String FXBS =map4.get("result").toString();
			
			list = transferDRDK_QKMX(grdkbm, HKKXQ, FLLX, ZNJFX, FXBS, hkrq);
			syyhpkList = yinhangpikou.syYinHangPiKouJe(zjzxdm, dkyh);
			YinHangPiKouCompareDto yinHangPiKouCompareDto = new YinHangPiKouCompareDto();
			for (Map<String, Object> sy : syyhpkList) {
				if (sy.get("GRDKBM")==grdkbm||sy.get("GRDKBM").equals(grdkbm)) {
					Double bj =Double.parseDouble(sy.get("BJ").toString());
					Double lx =Double.parseDouble(sy.get("LX").toString());
					Double fx =Double.parseDouble(sy.get("FX").toString());
					yinHangPiKouCompareDto.setSYBJ(bj);
					yinHangPiKouCompareDto.setSYLX(lx);
					yinHangPiKouCompareDto.setSYFX(fx);
					yinHangPiKouCompareDto.setSYHKJE(bj+lx+fx);
					break;
				}
			}
			for (TMP_YW_GDHK_QKMX_WH by : list) {
				System.err.println(by.toString());
				yinHangPiKouCompareDto.setBJ(by.getBCBJ());
				yinHangPiKouCompareDto.setFX(by.getBCZNJ()+by.getBCFLLX()+by.getBCZNJLX());
				yinHangPiKouCompareDto.setHKJE(by.getBCBJ()+(by.getBCZNJ()+by.getBCFLLX()+by.getBCZNJLX())+by.getBCLX());
				yinHangPiKouCompareDto.setLX(by.getBCLX());
			}
			yinHangPiKouCompareDto.setJkrxm((String)(grdkbmList.get(i).get("JKRXM")));
			yinHangPiKouCompareDto.setJkhtbh((String)(grdkbmList.get(i).get("JKHTBH")));
			yinHangPiKouCompareDto.setJkrzjh((String)(grdkbmList.get(i).get("JKRZJH")));
			yinHangPiKouCompareDto.setDkyh((String)(grdkbmList.get(i).get("DKYH")));
			yinHangPiKouCompareDto.setZjzxdm((String)(grdkbmList.get(i).get("ZJZXDM")));
			yinHangPiKouCompareDto.setGrdkbm(grdkbm);
			yinHangPiKouList.add(yinHangPiKouCompareDto);
			
			if (yinHangPiKouList.size()>=500) {
				yinhangpikou.insertJKYHPK(yinHangPiKouList);
				yinHangPiKouList = new ArrayList<>();
			}
			if (i==(grdkbmList.size()-1)&&yinHangPiKouList.size()!=0) {
				yinhangpikou.insertJKYHPK(yinHangPiKouList);
			}
			System.out.println(grdkbm+"-----"+yinhangpikou.toString());
			System.err.println(yinHangPiKouList.size());
		}
	}
	

	/**
	 * 调用CALC_GRDK_QKMX2存储过程查询临时表
	 * @throws IOException 
	 */
	@Override
	public List<TMP_YW_GDHK_QKMX_WH> transferDRDK_QKMX(String GRDKBM, String HKKXQ, String JXFS, String ZNJFX,String FXBS, Date HKRQ) throws IOException{
		String fileName = "mybatis.xml";
		InputStream inputStream = Resources.getResourceAsStream(fileName); 
		SqlSessionFactory sqlSessionFactory = new SqlSessionFactoryBuilder().build(inputStream);
	    SqlSession sqlSession = sqlSessionFactory.openSession(false);//通过这种方式打开的SqlSession，autoCommit默认为false，需要手动提交事务
	    DrdkQkmxDto drdkQkmxDto = new DrdkQkmxDto();
		drdkQkmxDto.setGrdkbm(GRDKBM);
		drdkQkmxDto.setHkkxq(HKKXQ);
		drdkQkmxDto.setJxfs(JXFS);
		drdkQkmxDto.setZnjfx(ZNJFX);
		drdkQkmxDto.setFxbs(FXBS);
		drdkQkmxDto.setHkrq(HKRQ);
		
		sqlSession.selectList("com.changda.gjjapp.gedai.dao.zhuyuehuakou.ZhuYueHuaKouCheckDao.DRDK_QKMX", drdkQkmxDto);
		//循环查询临时表
		List<Map<String, Object>> list2= sqlSession.selectList("com.changda.gjjapp.gedai.dao.zhuyuehuakou.ZhuYueHuaKouCheckDao.queryTMPGDHKQKMX");
		//提交事务
		sqlSession.commit();
		sqlSession.close();
	    inputStream.close();
		return null;
	}


	/**
	 * 查询银行批扣的人员
	 */
	@Override
	public List<Map<String, Object>> yinHangPiKouGrdkbm(String zjzxdm, Date hkrq, String dkyh) {
		List<Map<String, Object>> yinHangPiKouGrdkbmList = yinhangpikou.yinHangPiKouGrdkbm(zjzxdm, hkrq, dkyh);
		return yinHangPiKouGrdkbmList;
	}

	/**
	 * 插入数据到银行批扣表
	 */
	@Override
	public void insertJKYHPK(List<YinHangPiKouCompareDto> list) {
		
	}


	@Override
	public List<Map<String, Object>> yhpkData(String kjqj, String zjzxdm, String dkyh) {

		return null;
	}

	




}
