package com.changda.gjjapp.zhfwpt.dao.qdxxgl;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.changda.cd4j.foundation.core.persistence.annotation.MyBatisDao;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.HtjkDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdfwnldTjDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdgsjdTJDto;
import com.changda.gjjapp.zhfwpt.dto.qdxxgl.QdywblInFoDto;

@MyBatisDao
public interface QuDaoYeWuBanLiShuDao {

    /**
     * 单位渠道业务办理数量（成功、失败、待处理）显示   按日期查
     *
     * @param date 日期
     * @param num  接受（1.按月查2.按日期查）
     */
    List<Map<String, Object>> dWQuDaoBanLiShuL(@Param("qssj") String qssj, @Param("zzsj") String zzsj);

    /**
     * 单位渠道业务办理数量（成功、失败、待处理）显示   按年查
     *
     * @param date 日期
     * @param num  接受（1.按月查2.按日期查）
     */
    List<Map<String, Object>> dWQuDaoBanLiShuLTwo(@Param("qssj") String qssj, @Param("zzsj") String zzsj);


    /**
     * 个人渠道业务办理数量（成功、失败、待处理）显示   按日期查
     *
     * @param date 日期
     * @param num  接受（1.按月查2.按日期查）
     */
    List<Map<String, Object>> GrQuDaoBanLiShuL(@Param("qssj") String qssj, @Param("zzsj") String zzsj);

    /**
     * 个人渠道业务办理数量（成功、失败、待处理）显示   按年查
     *
     * @param date 日期
     * @param num  接受（1.按月查2.按日期查）
     */
    List<Map<String, Object>> GrQuDaoBanLiShuLTwo(@Param("qssj") String qssj, @Param("zzsj") String zzsj);

    /**
     * 后台监控所有渠道的业务办理实时监控
     */
    List<HtjkDto> htjkMonitor(@Param("ywlx")String ywlx,@Param("qdid")String qdid,@Param("qssj") String qssj, @Param("zzsj") String zzsj);
    
    
    /**
     * 所有业务类型
     * @return
     */
    List<Map<String, Object>> ywlx();
    
    /**
     * 渠道业务总办理量
     * @return
     */
    List<Map<String, Object>> qdywzbls();
    
    
    /**
     * 渠道业务办理量
     * @return
     */
    List<Map<String, Object>> qdywbls();
    
    
    /**
     * 渠道业务办理详情双击弹窗页面
     */
    List<QdywblInFoDto> qdywblInFo(@Param("ywlx")String ywlx);
    
    /**
     * 后台监控业务下拉框
     * @param ywfl 业务分类 1.单位业务2.个人业务
     * @return
     */
    List<Map<String, Object>> htjkywlx(@Param("ywfl")String ywfl,@Param("czlx")String czlx);
    
    /**
     * 渠道业务各年龄段办理数统计
     * @param qssj 
     * @param zzsj
     * @param ywbm
     * @return
     */
    List<QdfwnldTjDto> qdywblgnldTj(@Param("qssj")String qssj,@Param("zzsj")String zzsj,@Param("ywbm")String ywbm);
    
    /**
     * 渠道各时间段业务办理统计
     * @param qssj
     * @param zzsj
     * @param ywbm
     * @return
     */
    List<QdgsjdTJDto> qdywsjdblTJ(@Param("qssj")String qssj,@Param("zzsj")String zzsj,@Param("ywbm")String ywbm);
}
