package com.changda.gjjapp.zhfwpt.dao.zxhf;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.changda.cd4j.foundation.core.persistence.annotation.MyBatisDao;
import com.changda.gjjapp.db.entity.M_ANSWER;
import com.changda.gjjapp.db.entity.M_ZXLX;
import com.changda.gjjapp.zhfwpt.dto.zxhf.TouSuJianYiZiXunTypeSortDto;
import com.changda.gjjapp.zhfwpt.dto.zxhf.ZhiShiKuDiaoYongTJTuDto;
import com.changda.gjjapp.zhfwpt.dto.zxhf.ZhiShiKuDiaoYongTongJiFXDto;
import com.changda.gjjapp.zhfwpt.dto.zxhf.ZskLoggingDto;

@MyBatisDao
public interface ZxhfDao {

	
	List<M_ANSWER> query_M_ANSWER(@Param("lanmuid")String lanmuid,@Param("title")String title);
	
	//知识库调用统计图
	List<ZhiShiKuDiaoYongTJTuDto> query_ZhiShiKuDiaoYongTJTu(@Param("year")String year);
	
	//知识库调用统计分析
	List<ZhiShiKuDiaoYongTongJiFXDto> query_ZhiShiKuDiaoYongTongJiFX(@Param("year")String year);
	
	//投诉、建议、咨询类型排序
	List<TouSuJianYiZiXunTypeSortDto> query_TouSuJianYiZiXunTypeSort(@Param("year")String year,@Param("month")String month);
	
	/**
	 * 知识库列表
	 * @param title
	 * @param lanmuid
	 * @return
	 */
	List<M_ANSWER> zhishikuList(@Param("title")String title,@Param("lanmuid")String lanmuid);
	
	/**
	 * 答案信息
	 * @param primaryid
	 * @return
	 */
	M_ANSWER answerInfo(@Param("primaryid")String primaryid);
	
	/**
	 * 新增知识库信息
	 * @param title 标题
	 * @param lanmuid 栏目ID
	 * @param answer 答案
	 * @param czr 操作人
	 * @return
	 */
	int addZhiShiKuInfo(@Param("title")String title,@Param("lanmuid")String lanmuid,@Param("answer")String answer,@Param("czr")String czr);
	
	/**
	 * 修改知识库信息
	 * @param title 标题
	 * @param lanmuid 栏目ID
	 * @param answer 答案
	 * @param czr 操作人
	 * @param primaryid 主键ID
	 * @return
	 */
	int updateZhiShiKuInfo(@Param("title")String title,@Param("lanmuid")String lanmuid,@Param("answer")String answer,@Param("czr")String czr,@Param("primaryid")String primaryid);
	
	/**
	 * 删除知识库信息
	 * @param primaryid
	 * @return
	 */
	int deleteZhiShiKuInfo(@Param("primaryid")String primaryid);
		
	/**
	 * 操作知识库日志记录
	 * @param title
	 * @param czr
	 * @param czzt
	 * @return
	 */
	int zsk_Logging(@Param("title")String title,@Param("czr")String czr,@Param("czzt")String czzt,@Param("lanmuid")String lanmuid);
	
	/**
	 * 操作知识库日志记录查询
	 * @return
	 */
	List<ZskLoggingDto> zsk_Logging_select(@Param("lanmuid")String lanmuid);
}
