package com.changda.gjjapp.zhfwpt.service.impl.homepage;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.changda.cd4j.foundation.core.dto.ResultDto;
import com.changda.gjjapp.zhfwpt.dao.homepage.HomePageDao;
import com.changda.gjjapp.zhfwpt.dto.homepage.ComplaintRateDto;
import com.changda.gjjapp.zhfwpt.dto.homepage.LoginCountDto;
import com.changda.gjjapp.zhfwpt.dto.homepage.MydInfoDto;
import com.changda.gjjapp.zhfwpt.dto.homepage.SelectRCAndSl;
import com.changda.gjjapp.zhfwpt.dto.homepage.YwSortTop5Dto;
import com.changda.gjjapp.zhfwpt.service.homepage.HomePageService;

@Service()
public class HomePageServiceImp implements HomePageService{

	@Autowired
	private HomePageDao homepagedao;
	
	//首页用户投诉率
	@Override
	public ComplaintRateDto complaintRate(String year) {
		return homepagedao.complaintRate(year);
	}

	//问卷调查插入
	@Override
	public ResultDto insertWjdcInfo(String tpxx, String username, String grzh, String qdid,String ywlx) {
		ResultDto resultDto = new ResultDto();
		Map<String, Object> map = new HashMap<>();
		int zt = homepagedao.wjdcZT(grzh);
		if (zt>0) {
			map.put("reply", "1");
			resultDto.setData(map);
			resultDto.setSuccess(true);
		}else {
			map.put("reply", "0");
			resultDto.setData(map);
			int num = homepagedao.insertWjdcInfo(tpxx, username, grzh, qdid);
			String ywzt = "0";
			if (num>0) {
				ywzt = "1";
				homepagedao.insertWJDCXZ(qdid, ywlx,ywzt, grzh, username);
			}else {
				ywzt = "2";
				homepagedao.insertWJDCXZ(qdid, ywlx,ywzt, grzh, username);
			}
		}
		return resultDto;
	}

	//业务办理前五的数据
	@Override
	public List<YwSortTop5Dto> ywsortTop5() {
		// TODO Auto-generated method stub
		return homepagedao.ywsortTop5();
	}

	@Override
	public List<MydInfoDto> mydInfo(String year) {
		// TODO Auto-generated method stub
		return homepagedao.mydInfo(year);
	}

	@Override
	public List<LoginCountDto> loginCount() {
		// TODO Auto-generated method stub
		return homepagedao.loginCount();
	}

	//查询当天登录人次和登录次数
	@Override
	public List<SelectRCAndSl> selectRCAndSl() {
		// TODO Auto-generated method stub
		return homepagedao.selectRCAndSl();
	}

}
