package com.changda.gjjapp.zhfwpt.service.impl.qdywquanxiankz;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.changda.gjjapp.db.entity.M_YWZTKZ_2;
import com.changda.gjjapp.zhfwpt.dao.qdywqxgl.YeWuQuanXianGuanLiDao;
import com.changda.gjjapp.zhfwpt.dto.qdywqxgl.QDYWQuanXianGuanLiDto;
import com.changda.gjjapp.zhfwpt.service.qdywquanxiankz.YeWuQuanXianKongZhiService;

@Service
public class YeWuQuanXianKZServiceImp implements YeWuQuanXianKongZhiService {

    @Autowired
    private YeWuQuanXianGuanLiDao yeWuQuanXianGuanLiDao;

    //业务权限管理显示
    @Override
    public List<QDYWQuanXianGuanLiDto> ywztSreach(String qdid) {
        List<Map<String, Object>> dataList = yeWuQuanXianGuanLiDao.ywztSreach(qdid);
        List<QDYWQuanXianGuanLiDto> qdywlist = new ArrayList<>();
        for (Map<String, Object> map : dataList) {
            QDYWQuanXianGuanLiDto qDto = new QDYWQuanXianGuanLiDto();
            qDto.setQdid(map.get("QDID").toString());
            qDto.setYwmc(map.get("YWMC").toString());
            qDto.setYwbm(map.get("YWBM").toString());
            String zt = map.get("YWZT").toString();
            boolean flag = true;
            if (zt.equals("1")) {
                flag = true;
            } else if (zt.equals("0")) {
                flag = false;
            }
            qDto.setYwzt(flag);
            qdywlist.add(qDto);
        }
        return qdywlist;
    }

    //修改业务状态
    @Override
    public void updateYWZT(String ywzt, String qdid, String ywbm) {
        Integer ywztNum = Integer.parseInt(ywzt);
        yeWuQuanXianGuanLiDao.updateYWZT(ywztNum, qdid, ywbm);
    }

    //渠道业务权限管理
	@Override
	public List<QDYWQuanXianGuanLiDto> qdywkz(String qdid, String ywlxid) {
		List<Map<String, Object>> dataList = yeWuQuanXianGuanLiDao.qdywkz(qdid, ywlxid);
		List<QDYWQuanXianGuanLiDto> list = new ArrayList<QDYWQuanXianGuanLiDto>();
		for (Map<String, Object> map : dataList) {
			QDYWQuanXianGuanLiDto qDto = new QDYWQuanXianGuanLiDto();
			qDto.setQdid(map.get("QDID").toString());
			qDto.setYwbm(map.get("YWBM").toString());
			qDto.setQdywzt(map.get("YWZT").toString());
			list.add(qDto);
		}
		return list;
	}

}
